/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.SmithingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingTableInventoryImpl
extends SmithingTableInventory {
    public SmithingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a smithing table should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerSmithingTableImpl containerSmithingTable = new ContainerSmithingTableImpl(serverPlayer, items);
        serverPlayer.bV = containerSmithingTable;
        int id = containerSmithingTable.j;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        serverPlayer.b.sendPacket((Packet)new PacketPlayOutOpenWindow(id, Containers.u, message));
        this.sendItems(player, items, null);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack item) {
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(containerId, nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(-1, -1, net.minecraft.world.item.ItemStack.b);
        this.getPlayerConnection(this.getServerPlayer(player)).sendPacket((Packet)packet);
    }

    private void setCursor(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        this.getPlayerConnection(this.getServerPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, item));
    }

    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 2, item));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerSmithingTableImpl
    extends ContainerSmithing {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerSmithingTableImpl(@Nullable EntityPlayer serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.getInventory(), ContainerAccess.at((World)serverPlayer.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.player = serverPlayer.getBukkitEntity();
            this.p.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.p.setItem(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.o.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventorySmithing inventory = new CraftInventorySmithing(this.q.getLocation(), this.p, this.o){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return SmithingTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }
    }
}

