/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CycleButton
extends Pane {
    private final List<Pane> panes = new ArrayList<Pane>();
    private int position = 0;

    public CycleButton(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
    }

    public CycleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public CycleButton(@NotNull Slot slot, int length, int height) {
        super(slot, length, height);
    }

    public CycleButton(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public CycleButton(int length, int height) {
        super(length, height);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        int previousPosition = this.position++;
        if (this.position == this.panes.size()) {
            this.position = 0;
        }
        this.callOnClick(event);
        Pane pane = this.panes.get(previousPosition);
        pane.click(gui, inventoryComponent, event, slot, paneOffsetX + x, paneOffsetY + y, length, height);
        gui.update();
        return true;
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        Slot slot = this.getSlot();
        int newX = paneOffsetX + slot.getX(maxLength);
        int newY = paneOffsetY + slot.getY(maxLength);
        int newMaxLength = Math.min(maxLength, this.length);
        int newMaxHeight = Math.min(maxHeight, this.height);
        this.panes.get(this.position).display(inventoryComponent, newX, newY, newMaxLength, newMaxHeight);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public CycleButton copy() {
        CycleButton cycleButton = new CycleButton(this.getSlot(), this.length, this.height, this.getPriority());
        for (Pane pane : this.panes) {
            cycleButton.addPane(pane);
        }
        cycleButton.setVisible(this.isVisible());
        cycleButton.onClick = this.onClick;
        cycleButton.position = this.position;
        cycleButton.uuid = this.uuid;
        return cycleButton;
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toList());
    }

    public void addPane(int index, @NotNull Pane pane) {
        this.panes.add(index, pane);
    }

    public void addPane(@NotNull Pane pane) {
        this.panes.add(pane);
    }

    @Override
    public void clear() {
        this.panes.clear();
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return this.panes;
    }

    public void cycle() {
        ++this.position;
    }

    @NotNull
    public static CycleButton load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        CycleButton cycleButton = new CycleButton(length, height);
        Pane.load(cycleButton, instance, element);
        if (element.hasAttribute("populate")) {
            return cycleButton;
        }
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node pane = childNodes.item(j);
            if (pane.getNodeType() != 1) continue;
            cycleButton.addPane(Gui.loadPane(instance, pane, plugin));
        }
        return cycleButton;
    }

    @Deprecated
    @NotNull
    public static CycleButton load(@NotNull Object instance, @NotNull Element element) {
        return CycleButton.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(CycleButton.class));
    }
}

