/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.util.version;

import com.github.stefvanschie.inventoryframework.exception.UnsupportedVersionException;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum Version {
    V1_14,
    V1_15,
    V1_16_1,
    V1_16_2_3,
    V1_16_4_5,
    V1_17_0,
    V1_17_1,
    V1_18_0,
    V1_18_1,
    V1_18_2,
    V1_19_0,
    V1_19_1,
    V1_19_2,
    V1_19_3;


    @NotNull
    @Contract(pure=true)
    public static Version getVersion() {
        String version;
        switch (version = Bukkit.getBukkitVersion().split("-")[0]) {
            case "1.14": 
            case "1.14.1": 
            case "1.14.2": 
            case "1.14.3": 
            case "1.14.4": {
                return V1_14;
            }
            case "1.15": 
            case "1.15.1": 
            case "1.15.2": {
                return V1_15;
            }
            case "1.16.1": {
                return V1_16_1;
            }
            case "1.16.2": 
            case "1.16.3": {
                return V1_16_2_3;
            }
            case "1.16.4": 
            case "1.16.5": {
                return V1_16_4_5;
            }
            case "1.17": {
                return V1_17_0;
            }
            case "1.17.1": {
                return V1_17_1;
            }
            case "1.18": {
                return V1_18_0;
            }
            case "1.18.1": {
                return V1_18_1;
            }
            case "1.18.2": {
                return V1_18_2;
            }
            case "1.19": {
                return V1_19_0;
            }
            case "1.19.1": {
                return V1_19_1;
            }
            case "1.19.2": {
                return V1_19_2;
            }
            case "1.19.3": {
                return V1_19_3;
            }
        }
        throw new UnsupportedVersionException("The server version provided is not supported");
    }
}

