/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.RTPPlugin;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerGUI
implements Listener {
    private final Inventory inventory = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "RTP Menu"));

    public PlayerGUI(RTPPlugin plugin) {
        this.initializeItems();
    }

    public void openMenu(Player player) {
        player.openInventory(this.inventory);
    }

    private void initializeItems() {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, this.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, " ", new String[0]));
        }
        this.inventory.setItem(11, this.createGuiItem(Material.GRASS_BLOCK, String.valueOf(ChatColor.GREEN) + "Random Teleport", "Teleport to a random location"));
        this.inventory.setItem(13, this.createGuiItem(Material.ENDER_PEARL, String.valueOf(ChatColor.AQUA) + "RTP Back", "Return to your previous location"));
        this.inventory.setItem(15, this.createGuiItem(Material.PLAYER_HEAD, String.valueOf(ChatColor.GOLD) + "RTP Party", "Teleport with nearby players"));
        this.inventory.setItem(0, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Menu", new String[0]));
        this.inventory.setItem(8, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Menu", new String[0]));
        this.inventory.setItem(18, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Menu", new String[0]));
        this.inventory.setItem(26, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Menu", new String[0]));
    }

    private ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        if (lore.length > 0) {
            meta.setLore(Arrays.asList(lore));
        }
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        switch (event.getSlot()) {
            case 11: {
                player.performCommand("rtp");
                break;
            }
            case 13: {
                player.performCommand("rtpback");
                break;
            }
            case 15: {
                player.performCommand("rtpparty");
                break;
            }
            default: {
                return;
            }
        }
        player.closeInventory();
    }
}

