/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.ConfigGUI;
import com.funkel.rtpplugin.PlayerGUI;
import com.funkel.rtpplugin.RTPStatistics;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RTPPlugin
extends JavaPlugin
implements Listener {
    private int minRadius;
    private int maxRadius;
    private double cost;
    private String teleportMessage;
    private String onlyPlayersMessage;
    private String notEnoughMoneyMessage;
    private String moneyDeductedMessage;
    private Economy economy;
    private boolean economyEnabled = false;
    private int maxAttempts;
    private long searchTimeout;
    private HashMap<UUID, String> awaitingConfigInput = new HashMap();
    private ConfigGUI configGUI;
    private Map<UUID, Location> lastLocations;
    private RTPStatistics statistics;
    private PlayerGUI playerGUI;
    private final Random random = new Random();
    private int maxDistance;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        if (!this.getConfig().getBoolean("use-default-permissions", true)) {
            for (Permission permission : this.getDescription().getPermissions()) {
                permission.setDefault(PermissionDefault.FALSE);
            }
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, this::setupEconomy, 20L);
        this.configGUI = new ConfigGUI(this);
        this.playerGUI = new PlayerGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.configGUI, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerGUI, (Plugin)this);
        this.getLogger().info("RTP Plugin v1.9-SNAPSHOT has been enabled!");
        this.lastLocations = new HashMap<UUID, Location>();
        this.statistics = new RTPStatistics(this);
        this.registerCommand("rtpstats", (CommandExecutor)this);
        this.registerCommand("rtpconfig", (CommandExecutor)this);
        this.registerCommand("rtp", (CommandExecutor)this);
        this.registerCommand("rtpmenu", (CommandExecutor)this);
        this.registerCommand("rtpback", (CommandExecutor)this);
        this.registerCommand("rtpparty", (CommandExecutor)this);
        this.maxDistance = this.getConfig().getInt("rtp.max-radius", 5000);
    }

    public void onDisable() {
        this.statistics.saveStats();
        this.getLogger().info("RTP Plugin v1.9-SNAPSHOT has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.minRadius = config.getInt("rtp.min-radius", 1000);
        this.maxRadius = config.getInt("rtp.max-radius", 5000);
        this.cost = config.getDouble("rtp.cost", 0.0);
        this.teleportMessage = config.getString("rtp.messages.teleported", "You have been teleported to a random location!");
        this.onlyPlayersMessage = config.getString("rtp.messages.only-players", "This command can only be executed by players!");
        this.notEnoughMoneyMessage = config.getString("rtp.messages.not-enough-money", "You don't have enough money for the RTP command. Required: %cost%");
        this.moneyDeductedMessage = config.getString("rtp.messages.money-deducted", "%cost% has been deducted from your account.");
        this.maxAttempts = config.getInt("rtp.max-attempts", 50);
        this.searchTimeout = config.getLong("rtp.search-timeout", 5000L);
        this.saveConfig();
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found. Economy features will be disabled.");
            this.economyEnabled = false;
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("No economy provider found. Economy features will be disabled.");
            this.economyEnabled = false;
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.economyEnabled = true;
        this.getLogger().info("Vault found and economy initialized successfully. Economy features are enabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.onlyPlayersMessage);
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "rtp": {
                if (!player.hasPermission("rtp.use")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args.length > 0 && args[0].equalsIgnoreCase("biome")) {
                    return this.handleRtpBiomeCommand(player, args);
                }
                return this.handleRtpCommand(player, args);
            }
            case "rtpback": {
                if (!player.hasPermission("rtp.back")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                return this.handleRtpBackCommand(player);
            }
            case "rtpparty": {
                if (!player.hasPermission("rtp.party")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                return this.handleRtpPartyCommand(player);
            }
            case "rtpconfig": {
                if (!player.hasPermission("rtp.config")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.configGUI.openConfigMenu(player);
                return true;
            }
            case "rtpstats": {
                if (!player.hasPermission("rtp.stats")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view RTP statistics.");
                    return true;
                }
                return this.handleRtpStatsCommand((CommandSender)player);
            }
            case "rtpmenu": {
                if (!player.hasPermission("rtp.menu")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.playerGUI.openMenu(player);
                return true;
            }
        }
        return false;
    }

    private boolean handleRtpCommand(Player player, String[] args) {
        Location randomLocation;
        Biome targetBiome = null;
        if (args.length > 1 && args[0].equalsIgnoreCase("biome")) {
            try {
                targetBiome = Biome.valueOf((String)args[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid biome specified.");
                return true;
            }
        }
        if (this.economyEnabled && this.cost > 0.0) {
            if (!this.economy.has((OfflinePlayer)player, this.cost)) {
                player.sendMessage(this.notEnoughMoneyMessage.replace("%cost%", String.format("%.2f", this.cost)));
                return true;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, this.cost);
            player.sendMessage(this.moneyDeductedMessage.replace("%cost%", String.format("%.2f", this.cost)));
        }
        if ((randomLocation = this.getRandomLocation(player.getWorld().getSpawnLocation(), this.minRadius, this.maxRadius, targetBiome)) == null) {
            player.sendMessage(this.getConfig().getString("rtp.messages.no-safe-location", "Could not find a safe location. Please try again."));
            return true;
        }
        double distance = player.getLocation().distance(randomLocation);
        this.statistics.recordTeleport(player, distance, randomLocation.getBlock().getBiome());
        this.lastLocations.put(player.getUniqueId(), player.getLocation());
        player.teleport(randomLocation);
        player.sendMessage(this.teleportMessage);
        return true;
    }

    private boolean handleRtpBackCommand(Player player) {
        Location lastLocation = this.lastLocations.get(player.getUniqueId());
        if (lastLocation == null) {
            player.sendMessage(this.getConfig().getString("rtp.messages.no-previous-location", "You don't have a previous RTP location to return to."));
            return true;
        }
        player.teleport(lastLocation);
        this.lastLocations.remove(player.getUniqueId());
        player.sendMessage(this.getConfig().getString("rtp.messages.teleported", "You have been teleported to your previous location!"));
        return true;
    }

    private boolean handleRtpPartyCommand(Player player) {
        Location randomLocation = this.getRandomLocation(player.getWorld().getSpawnLocation(), this.minRadius, this.maxRadius, null);
        if (randomLocation == null) {
            player.sendMessage(this.getConfig().getString("rtp.messages.no-safe-location", "Could not find a safe location. Please try again."));
            return true;
        }
        for (Player partyMember : player.getWorld().getPlayers()) {
            if (!(partyMember.getLocation().distance(player.getLocation()) <= 10.0)) continue;
            this.lastLocations.put(partyMember.getUniqueId(), partyMember.getLocation());
            partyMember.teleport(randomLocation);
            partyMember.sendMessage(this.getConfig().getString("rtp.messages.party-teleported", "Your party has been teleported to a random location!"));
        }
        return true;
    }

    private boolean handleRtpStatsCommand(CommandSender sender) {
        if (!sender.hasPermission("rtp.stats")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view RTP statistics.");
            return true;
        }
        sender.sendMessage(this.statistics.getStats());
        if (sender instanceof Player) {
            Player player = (Player)sender;
            sender.sendMessage("\u00a77Your RTP uses: \u00a7f" + this.statistics.getPlayerUses(player.getUniqueId()));
        }
        return true;
    }

    private boolean handleRtpBiomeCommand(Player player, String[] args) {
        Biome targetBiome;
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rtp biome <biomeName>");
            return true;
        }
        String biomeName = args[1].toUpperCase();
        try {
            targetBiome = Biome.valueOf((String)biomeName);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid biome name. Please try again.");
            return true;
        }
        if (this.economyEnabled && this.cost > 0.0) {
            if (!this.economy.has((OfflinePlayer)player, this.cost)) {
                player.sendMessage(this.notEnoughMoneyMessage.replace("%cost%", String.format("%.2f", this.cost)));
                return true;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, this.cost);
            player.sendMessage(this.moneyDeductedMessage.replace("%cost%", String.format("%.2f", this.cost)));
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attempting to teleport to " + targetBiome.name() + " biome...");
        Location randomLocation = this.getRandomLocation(player.getWorld().getSpawnLocation(), this.minRadius, this.maxRadius, targetBiome);
        if (randomLocation == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find a safe location in the specified biome. Please try again.");
            return true;
        }
        double distance = player.getLocation().distance(randomLocation);
        this.statistics.recordTeleport(player, distance, randomLocation.getBlock().getBiome());
        this.lastLocations.put(player.getUniqueId(), player.getLocation());
        player.teleport(randomLocation);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to a " + targetBiome.name() + " biome!");
        return true;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.awaitingConfigInput.containsKey(playerUUID)) {
            event.setCancelled(true);
            String configKey = this.awaitingConfigInput.get(playerUUID);
            String input = event.getMessage();
            boolean success = this.updateConfig(configKey, input, player);
            if (success) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration updated successfully!");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to update configuration. Please try again.");
            }
            this.awaitingConfigInput.remove(playerUUID);
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.configGUI.openConfigMenu(player), 10L);
        }
    }

    private Location getRandomLocation(Location center, int minRadius, int maxRadius, Biome targetBiome) {
        Random random = new Random();
        World world = center.getWorld();
        long startTime = System.currentTimeMillis();
        for (int attempts = 0; attempts < this.maxAttempts; ++attempts) {
            if (System.currentTimeMillis() - startTime > this.searchTimeout) {
                this.getLogger().warning("RTP search timed out after " + this.searchTimeout + "ms.");
                return null;
            }
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int radius = random.nextInt(maxRadius - minRadius) + minRadius;
            int x = (int)(center.getX() + (double)radius * Math.cos(angle));
            int z = (int)(center.getZ() + (double)radius * Math.sin(angle));
            int y = world.getHighestBlockYAt(x, z);
            Location location = new Location(world, (double)x, (double)(y + 1), (double)z);
            this.getLogger().info("Attempt " + (attempts + 1) + ": Checking location " + String.valueOf(location));
            if (targetBiome != null && location.getBlock().getBiome() != targetBiome || !this.isSafeLocation(location)) continue;
            this.getLogger().info("Safe location found at " + String.valueOf(location));
            return location;
        }
        this.getLogger().warning("Could not find a safe location after " + this.maxAttempts + " attempts.");
        return null;
    }

    private boolean isSafeLocation(Location location) {
        boolean safe;
        Block feet = location.getBlock();
        Block ground = feet.getRelative(0, -1, 0);
        Block head = feet.getRelative(0, 1, 0);
        boolean bl = safe = !feet.isLiquid() && !ground.isLiquid() && !head.isLiquid() && ground.getType().isSolid() && !this.isUnsafeGround(ground.getType());
        if (!safe) {
            this.getLogger().info("Unsafe location: " + String.valueOf(location) + " (feet: " + String.valueOf(feet.getType()) + ", ground: " + String.valueOf(ground.getType()) + ", head: " + String.valueOf(head.getType()) + ")");
        }
        return safe;
    }

    private boolean isUnsafeGround(Material material) {
        return material == Material.LAVA || material == Material.WATER || material == Material.SAND || material == Material.GRAVEL;
    }

    public double getCost() {
        return this.cost;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public HashMap<UUID, String> getAwaitingConfigInput() {
        return this.awaitingConfigInput;
    }

    private void playTeleportEffects(Player player, Location from, final Location to) {
        from.getWorld().spawnParticle(Particle.PORTAL, from, 100, 0.5, 1.0, 0.5, 0.5);
        from.getWorld().playSound(from, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        to.getWorld().spawnParticle(Particle.PORTAL, to, 100, 0.5, 1.0, 0.5, 0.5);
        to.getWorld().playSound(to, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                to.getWorld().spawnParticle(Particle.PORTAL, to, 10, 0.5, 1.0, 0.5, 0.1);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    public boolean teleportPlayer(Player player) {
        Location to;
        Location from = player.getLocation();
        World world = player.getWorld();
        if (this.economyEnabled && this.cost > 0.0) {
            if (!this.economy.has((OfflinePlayer)player, this.cost)) {
                player.sendMessage(this.notEnoughMoneyMessage.replace("%cost%", String.format("%.2f", this.cost)));
                return false;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, this.cost);
            player.sendMessage(this.moneyDeductedMessage.replace("%cost%", String.format("%.2f", this.cost)));
        }
        if ((to = this.getRandomLocation(world.getSpawnLocation(), this.minRadius, this.maxRadius, null)) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find a safe location to teleport to.");
            return false;
        }
        player.teleport(to);
        this.playTeleportEffects(player, from, to);
        double distance = from.distance(to);
        this.statistics.recordTeleport(player, distance, to.getBlock().getBiome());
        this.lastLocations.put(player.getUniqueId(), from);
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.teleportMessage));
        return true;
    }

    private Location getSafeLocation(World world, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        Location loc = new Location(world, (double)x, (double)y, (double)z);
        if (this.isSafe(loc)) {
            return loc;
        }
        return null;
    }

    private int getRandomCoordinate() {
        return this.random.nextInt(this.maxDistance * 2) - this.maxDistance;
    }

    private boolean isSafe(Location location) {
        Block feet = location.getBlock();
        Block ground = feet.getRelative(0, -1, 0);
        Block head = feet.getRelative(0, 1, 0);
        return !feet.isLiquid() && !ground.isLiquid() && !feet.getType().isSolid() && !head.getType().isSolid() && ground.getType().isSolid();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
    }

    public void updateConfig(String key, Object value) {
        this.getConfig().set(key, value);
        this.saveConfig();
        this.loadConfig();
    }

    public String getTeleportMessage() {
        return this.teleportMessage;
    }

    public String getOnlyPlayersMessage() {
        return this.onlyPlayersMessage;
    }

    public String getNotEnoughMoneyMessage() {
        return this.notEnoughMoneyMessage;
    }

    public String getMoneyDeductedMessage() {
        return this.moneyDeductedMessage;
    }

    public void setTeleportMessage(String message) {
        this.teleportMessage = message;
        this.getConfig().set("rtp.messages.teleported", (Object)message);
        this.saveConfig();
    }

    public void setOnlyPlayersMessage(String message) {
        this.onlyPlayersMessage = message;
        this.getConfig().set("rtp.messages.only-players", (Object)message);
        this.saveConfig();
    }

    public void setNotEnoughMoneyMessage(String message) {
        this.notEnoughMoneyMessage = message;
        this.getConfig().set("rtp.messages.not-enough-money", (Object)message);
        this.saveConfig();
    }

    public void setMoneyDeductedMessage(String message) {
        this.moneyDeductedMessage = message;
        this.getConfig().set("rtp.messages.money-deducted", (Object)message);
        this.saveConfig();
    }

    public void setCost(double newCost) {
        this.cost = newCost;
        this.getConfig().set("rtp.cost", (Object)newCost);
        this.saveConfig();
    }

    public void setMinRadius(int newMinRadius) {
        this.minRadius = newMinRadius;
        this.getConfig().set("rtp.min-radius", (Object)newMinRadius);
        this.saveConfig();
    }

    public void setMaxRadius(int newMaxRadius) {
        this.maxRadius = newMaxRadius;
        this.getConfig().set("rtp.max-radius", (Object)newMaxRadius);
        this.saveConfig();
    }

    public boolean updateConfig(String key, String value, Player player) {
        try {
            switch (key) {
                case "rtp.cost": {
                    double newCost = Double.parseDouble(value);
                    this.setCost(newCost);
                    break;
                }
                case "rtp.min-radius": {
                    int newMinRadius = Integer.parseInt(value);
                    this.setMinRadius(newMinRadius);
                    break;
                }
                case "rtp.max-radius": {
                    int newMaxRadius = Integer.parseInt(value);
                    this.setMaxRadius(newMaxRadius);
                    break;
                }
                default: {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown configuration key: " + key);
                    return false;
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid input. Please enter a number.");
            return false;
        }
    }

    private void registerCommand(String commandName, CommandExecutor executor) {
        PluginCommand command = this.getCommand(commandName);
        if (command != null) {
            command.setExecutor(executor);
        } else {
            this.getLogger().warning("Failed to register command: " + commandName);
        }
    }
}

