/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.RTPPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.block.Biome;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class RTPStatistics {
    private final RTPPlugin plugin;
    private final File statsFile;
    private YamlConfiguration stats;
    private int totalUses;
    private double totalDistance;
    private Map<Biome, Integer> biomeCounts;
    private Map<UUID, Integer> playerUses;

    public RTPStatistics(RTPPlugin plugin) {
        this.plugin = plugin;
        this.statsFile = new File(plugin.getDataFolder(), "stats.yml");
        this.biomeCounts = new HashMap<Biome, Integer>();
        this.playerUses = new HashMap<UUID, Integer>();
        this.loadStats();
    }

    private void loadStats() {
        if (!this.statsFile.exists()) {
            this.plugin.saveResource("stats.yml", false);
        }
        this.stats = YamlConfiguration.loadConfiguration((File)this.statsFile);
        this.totalUses = this.stats.getInt("totalUses", 0);
        this.totalDistance = this.stats.getDouble("totalDistance", 0.0);
        if (this.stats.contains("biomeCounts")) {
            for (String biome : this.stats.getConfigurationSection("biomeCounts").getKeys(false)) {
                this.biomeCounts.put(Biome.valueOf((String)biome), this.stats.getInt("biomeCounts." + biome));
            }
        }
        if (this.stats.contains("playerUses")) {
            for (String uuid : this.stats.getConfigurationSection("playerUses").getKeys(false)) {
                this.playerUses.put(UUID.fromString(uuid), this.stats.getInt("playerUses." + uuid));
            }
        }
    }

    public void saveStats() {
        this.stats.set("totalUses", (Object)this.totalUses);
        this.stats.set("totalDistance", (Object)this.totalDistance);
        for (Map.Entry<Biome, Integer> entry : this.biomeCounts.entrySet()) {
            this.stats.set("biomeCounts." + entry.getKey().name(), (Object)entry.getValue());
        }
        for (Map.Entry<Object, Integer> entry : this.playerUses.entrySet()) {
            this.stats.set("playerUses." + ((UUID)entry.getKey()).toString(), (Object)entry.getValue());
        }
        try {
            this.stats.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save stats file: " + e.getMessage());
        }
    }

    public void recordTeleport(Player player, double distance, Biome biome) {
        ++this.totalUses;
        this.totalDistance += distance;
        this.biomeCounts.put(biome, this.biomeCounts.getOrDefault(biome, 0) + 1);
        this.playerUses.put(player.getUniqueId(), this.playerUses.getOrDefault(player.getUniqueId(), 0) + 1);
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76RTP Statistics:\n");
        sb.append("\u00a77Total uses: \u00a7f").append(this.totalUses).append("\n");
        sb.append("\u00a77Total distance: \u00a7f").append(String.format("%.2f", this.totalDistance)).append(" blocks\n");
        sb.append("\u00a77Top 3 biomes:\n");
        this.biomeCounts.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).limit(3L).forEach(e -> sb.append("  \u00a77").append(e.getKey()).append(": \u00a7f").append(e.getValue()).append("\n"));
        return sb.toString();
    }

    public int getPlayerUses(UUID playerUUID) {
        return this.playerUses.getOrDefault(playerUUID, 0);
    }
}

