/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.RTPPlugin;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ConfigGUI
implements Listener {
    private final RTPPlugin plugin;
    private final Inventory inventory;

    public ConfigGUI(RTPPlugin plugin) {
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "RTP Config"));
        this.updateInventory();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openConfigMenu(Player player) {
        this.updateInventory();
        player.openInventory(this.inventory);
    }

    private void updateInventory() {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, " "));
        }
        this.inventory.setItem(10, this.createConfigItem(Material.GOLD_INGOT, "Cost", this.plugin.getCost()));
        this.inventory.setItem(13, this.createConfigItem(Material.REDSTONE, "Min Radius", this.plugin.getMinRadius()));
        this.inventory.setItem(16, this.createConfigItem(Material.GLOWSTONE_DUST, "Max Radius", this.plugin.getMaxRadius()));
        this.inventory.setItem(0, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Config"));
        this.inventory.setItem(8, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Config"));
        this.inventory.setItem(18, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Config"));
        this.inventory.setItem(26, this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP Config"));
    }

    private ItemStack createGuiItem(Material material, String name) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createConfigItem(Material material, String name, double value) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + name + ": " + value);
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Left-click to increase")));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Right-click to decrease")));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createToggleItem(Material material, String name, boolean enabled) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + name);
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(enabled ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled")));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to toggle")));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        switch (event.getSlot()) {
            case 10: {
                this.handleCostChange(player, event.isRightClick());
                break;
            }
            case 13: {
                this.handleMinRadiusChange(player, event.isRightClick());
                break;
            }
            case 16: {
                this.handleMaxRadiusChange(player, event.isRightClick());
            }
        }
        this.updateInventory();
        player.updateInventory();
    }

    private void handleCostChange(Player player, boolean decrease) {
        double currentCost = this.plugin.getCost();
        double newCost = decrease ? currentCost - 1.0 : currentCost + 1.0;
        newCost = Math.max(0.0, newCost);
        this.plugin.setCost(newCost);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Cost updated to " + newCost);
    }

    private void handleMinRadiusChange(Player player, boolean decrease) {
        int currentMinRadius = this.plugin.getMinRadius();
        int newMinRadius = decrease ? currentMinRadius - 10 : currentMinRadius + 10;
        newMinRadius = Math.max(0, newMinRadius);
        this.plugin.setMinRadius(newMinRadius);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Minimum radius updated to " + newMinRadius);
    }

    private void handleMaxRadiusChange(Player player, boolean decrease) {
        int currentMaxRadius = this.plugin.getMaxRadius();
        int newMaxRadius = decrease ? currentMaxRadius - 10 : currentMaxRadius + 10;
        newMaxRadius = Math.max(this.plugin.getMinRadius(), newMaxRadius);
        this.plugin.setMaxRadius(newMaxRadius);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Maximum radius updated to " + newMaxRadius);
    }
}

