/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import ic2.api.item.ElectricItem;
import ic2.core.item.tool.HarvestLevel;
import ic2.core.item.tool.ItemDrill;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BaseDrill
extends ItemDrill {
    protected static final String NBT_ROOT = "adv_drill_data";
    protected static final String NBT_MODE = "Mode";
    protected static final String MODE_NONE = "NONE";
    protected static final String MODE_SILK = "SILK";
    protected static final String MODE_FORTUNE = "FORTUNE";
    protected static final String MODE_AOE_SMALL = "AOE_3x3";
    protected static final String MODE_AOE_MEDIUM = "AOE_5x5";
    protected static final String MODE_AOE_LARGE = "AOE_7x7";
    protected static final String MODE_VEIN_1 = "VEIN_I";
    protected static final String MODE_VEIN_2 = "VEIN_II";
    protected static final String MODE_AOE_LEGACY = "3x3";
    protected static final String MODE_VEIN_LEGACY = "VEIN";
    protected final int opEnergyCost;
    protected final HarvestLevel harvestLevelCfg;
    protected final int maxCharge;
    protected final int transferLimit;
    protected final int tier;
    protected final float field_77864_a;
    protected final int energyUse;
    protected final int breakTime;
    protected final double blockCost;
    protected final boolean enableSilk;
    protected final boolean enableFortune;
    protected final int fortuneLevel;
    protected final boolean enableAoeSmall;
    protected final int aoeSmallRadius;
    protected final double aoeSmallBlockCost;
    protected final boolean enableAoeMedium;
    protected final int aoeMediumRadius;
    protected final double aoeMediumBlockCost;
    protected final boolean enableAoeLarge;
    protected final int aoeLargeRadius;
    protected final double aoeLargeBlockCost;
    protected final boolean enableVein1;
    protected final int vein1MaxBlocks;
    protected final int vein1MaxDistance;
    protected final double vein1BlockCost;
    protected final boolean enableVein2;
    protected final int vein2MaxBlocks;
    protected final int vein2MaxDistance;
    protected final double vein2BlockCost;

    public BaseDrill(String name, int opEnergyCost, HarvestLevel harvestLevel, int maxCharge, int transferLimit, int tier, float efficiency, int energyUse, int breakTime, double blockCost, int fortuneLevel, boolean enableSilk, boolean enableFortune, boolean enableAoe, int aoeRadius, double aoeBlockCost) {
        this(name, opEnergyCost, harvestLevel, maxCharge, transferLimit, tier, efficiency, energyUse, breakTime, blockCost, fortuneLevel, enableSilk, enableFortune, enableAoe, aoeRadius, aoeBlockCost, false, 0, 0.0, false, 0, 0.0, false, 0, 0, 0.0, false, 0, 0, 0.0);
    }

    public BaseDrill(String name, int opEnergyCost, HarvestLevel harvestLevel, int maxCharge, int transferLimit, int tier, float efficiency, int energyUse, int breakTime, double blockCost, int fortuneLevel, boolean enableSilk, boolean enableFortune, boolean enableAoeSmall, int aoeSmallRadius, double aoeSmallBlockCost, boolean enableAoeMedium, int aoeMediumRadius, double aoeMediumBlockCost) {
        this(name, opEnergyCost, harvestLevel, maxCharge, transferLimit, tier, efficiency, energyUse, breakTime, blockCost, fortuneLevel, enableSilk, enableFortune, enableAoeSmall, aoeSmallRadius, aoeSmallBlockCost, enableAoeMedium, aoeMediumRadius, aoeMediumBlockCost, false, 0, 0.0, false, 0, 0, 0.0, false, 0, 0, 0.0);
    }

    public BaseDrill(String name, int opEnergyCost, HarvestLevel harvestLevel, int maxCharge, int transferLimit, int tier, float efficiency, int energyUse, int breakTime, double blockCost, int fortuneLevel, boolean enableSilk, boolean enableFortune, boolean enableAoeSmall, int aoeSmallRadius, double aoeSmallBlockCost, boolean enableAoeMedium, int aoeMediumRadius, double aoeMediumBlockCost, boolean enableAoeLarge, int aoeLargeRadius, double aoeLargeBlockCost, boolean enableVein1, int vein1MaxBlocks, int vein1MaxDistance, double vein1BlockCost, boolean enableVein2, int vein2MaxBlocks, int vein2MaxDistance, double vein2BlockCost) {
        super(null, opEnergyCost, harvestLevel, maxCharge, transferLimit, tier, efficiency);
        this.opEnergyCost = opEnergyCost;
        this.harvestLevelCfg = harvestLevel;
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.field_77864_a = efficiency;
        this.energyUse = energyUse;
        this.breakTime = breakTime;
        this.blockCost = blockCost;
        this.fortuneLevel = Math.max(1, fortuneLevel);
        this.enableSilk = enableSilk;
        this.enableFortune = enableFortune;
        this.enableAoeSmall = enableAoeSmall && aoeSmallRadius > 0;
        this.aoeSmallRadius = aoeSmallRadius;
        this.aoeSmallBlockCost = aoeSmallBlockCost;
        this.enableAoeMedium = enableAoeMedium && aoeMediumRadius > 0;
        this.aoeMediumRadius = aoeMediumRadius;
        this.aoeMediumBlockCost = aoeMediumBlockCost;
        this.enableAoeLarge = enableAoeLarge && aoeLargeRadius > 0;
        this.aoeLargeRadius = aoeLargeRadius;
        this.aoeLargeBlockCost = aoeLargeBlockCost;
        this.enableVein1 = enableVein1 && vein1MaxBlocks > 0;
        this.vein1MaxBlocks = Math.max(0, vein1MaxBlocks);
        this.vein1MaxDistance = Math.max(0, vein1MaxDistance);
        this.vein1BlockCost = vein1BlockCost;
        this.enableVein2 = enableVein2 && vein2MaxBlocks > 0;
        this.vein2MaxBlocks = Math.max(0, vein2MaxBlocks);
        this.vein2MaxDistance = Math.max(0, vein2MaxDistance);
        this.vein2BlockCost = vein2BlockCost;
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        ItemInit.ITEMS.add((Item)this);
    }

    public int energyUse(ItemStack s, World w, BlockPos p, IBlockState st) {
        return this.energyUse;
    }

    public int breakTime(ItemStack s, World w, BlockPos p, IBlockState st) {
        return this.breakTime;
    }

    private boolean tryUseEUFromAnySource(ItemStack stack, EntityPlayer player, double eu) {
        return ElectricItem.manager.use(stack, eu, (EntityLivingBase)player);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTTagCompound tag = stack.func_190925_c(NBT_ROOT);
            String mode = this.normalizeMode(tag.func_74779_i(NBT_MODE));
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_82580_o("ench");
            }
            if (player.func_70093_af()) {
                tag.func_74778_a(NBT_MODE, MODE_NONE);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Enchantments disabled"));
            } else {
                String next = this.nextMode(mode);
                tag.func_74778_a(NBT_MODE, next);
                if (MODE_SILK.equals(next)) {
                    stack.func_77966_a(Enchantments.field_185306_r, 1);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Switched to Silk Touch"));
                } else if (MODE_FORTUNE.equals(next)) {
                    stack.func_77966_a(Enchantments.field_185308_t, this.fortuneLevel);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Switched to Fortune " + this.fortuneLevel));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Switched to " + this.labelFor(next)));
                }
            }
            player.field_71071_by.func_70296_d();
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    protected String normalizeMode(String mode) {
        if (mode == null || mode.isEmpty()) {
            return MODE_NONE;
        }
        if (MODE_AOE_LEGACY.equals(mode)) {
            return MODE_AOE_SMALL;
        }
        if (MODE_VEIN_LEGACY.equals(mode)) {
            return MODE_VEIN_1;
        }
        return mode;
    }

    protected String nextMode(String current) {
        int idx;
        ArrayList<String> cycle = new ArrayList<String>();
        cycle.add(MODE_NONE);
        if (this.enableSilk) {
            cycle.add(MODE_SILK);
        }
        if (this.enableFortune) {
            cycle.add(MODE_FORTUNE);
        }
        if (this.enableAoeSmall) {
            cycle.add(MODE_AOE_SMALL);
        }
        if (this.enableAoeMedium) {
            cycle.add(MODE_AOE_MEDIUM);
        }
        if (this.enableAoeLarge) {
            cycle.add(MODE_AOE_LARGE);
        }
        if (this.enableVein1) {
            cycle.add(MODE_VEIN_1);
        }
        if (this.enableVein2) {
            cycle.add(MODE_VEIN_2);
        }
        if ((idx = cycle.indexOf(current)) < 0) {
            idx = 0;
        }
        return (String)cycle.get((idx + 1) % cycle.size());
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a(NBT_ROOT);
        if (tag == null) {
            return false;
        }
        String mode = this.normalizeMode(tag.func_74779_i(NBT_MODE));
        return MODE_SILK.equals(mode) || MODE_FORTUNE.equals(mode) || MODE_AOE_SMALL.equals(mode) || MODE_AOE_MEDIUM.equals(mode) || MODE_AOE_LARGE.equals(mode) || MODE_VEIN_1.equals(mode) || MODE_VEIN_2.equals(mode);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound tag = stack.func_179543_a(NBT_ROOT);
        String mode = this.normalizeMode(tag != null ? tag.func_74779_i(NBT_MODE) : MODE_NONE);
        String nice = MODE_SILK.equals(mode) ? "Silk Touch" : (MODE_FORTUNE.equals(mode) ? "Fortune " + this.fortuneLevel : (MODE_AOE_SMALL.equals(mode) ? this.labelFor(MODE_AOE_SMALL) : (MODE_AOE_MEDIUM.equals(mode) ? this.labelFor(MODE_AOE_MEDIUM) : (MODE_AOE_LARGE.equals(mode) ? this.labelFor(MODE_AOE_LARGE) : (MODE_VEIN_1.equals(mode) ? "Vein Miner I" : (MODE_VEIN_2.equals(mode) ? "Vein Miner II" : "None"))))));
        tooltip.add(TextFormatting.YELLOW + "Current Mode: " + TextFormatting.WHITE + nice);
        tooltip.add(TextFormatting.YELLOW + "Right-click to toggle:");
        this.addModeLine(tooltip, MODE_NONE.equals(mode), "None");
        if (this.enableSilk) {
            this.addModeLine(tooltip, MODE_SILK.equals(mode), "Silk Touch");
        }
        if (this.enableFortune) {
            this.addModeLine(tooltip, MODE_FORTUNE.equals(mode), "Fortune " + this.fortuneLevel);
        }
        if (this.enableVein1) {
            this.addModeLine(tooltip, MODE_VEIN_1.equals(mode), "Vein Miner I");
        }
        if (this.enableVein2) {
            this.addModeLine(tooltip, MODE_VEIN_2.equals(mode), "Vein Miner II");
        }
        if (this.enableAoeSmall) {
            this.addModeLine(tooltip, MODE_AOE_SMALL.equals(mode), this.labelFor(MODE_AOE_SMALL));
        }
        if (this.enableAoeMedium) {
            this.addModeLine(tooltip, MODE_AOE_MEDIUM.equals(mode), this.labelFor(MODE_AOE_MEDIUM));
        }
        if (this.enableAoeLarge) {
            this.addModeLine(tooltip, MODE_AOE_LARGE.equals(mode), this.labelFor(MODE_AOE_LARGE));
        }
    }

    protected String labelFor(String mode) {
        if (MODE_AOE_SMALL.equals(mode)) {
            int s = 2 * this.aoeSmallRadius + 1;
            return s + "x" + s;
        }
        if (MODE_AOE_MEDIUM.equals(mode)) {
            int s = 2 * this.aoeMediumRadius + 1;
            return s + "x" + s;
        }
        if (MODE_AOE_LARGE.equals(mode)) {
            int s = 2 * this.aoeLargeRadius + 1;
            return s + "x" + s;
        }
        if (MODE_VEIN_1.equals(mode)) {
            return "Vein Miner I";
        }
        if (MODE_VEIN_2.equals(mode)) {
            return "Vein Miner II";
        }
        return "AOE";
    }

    protected void addModeLine(List<String> tooltip, boolean active, String label) {
        tooltip.add((active ? TextFormatting.WHITE : TextFormatting.YELLOW) + " - " + label);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        boolean centerOk = super.func_179218_a(stack, world, state, pos, entity);
        if (world.field_72995_K) {
            return centerOk;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return centerOk;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        NBTTagCompound tag = stack.func_179543_a(NBT_ROOT);
        String mode = this.normalizeMode(tag == null ? MODE_NONE : tag.func_74779_i(NBT_MODE));
        if (MODE_AOE_SMALL.equals(mode) && this.enableAoeSmall) {
            this.doPlaneAOE(world, player, stack, pos, this.aoeSmallRadius, this.aoeSmallBlockCost);
            return centerOk;
        }
        if (MODE_AOE_MEDIUM.equals(mode) && this.enableAoeMedium) {
            this.doPlaneAOE(world, player, stack, pos, this.aoeMediumRadius, this.aoeMediumBlockCost);
            return centerOk;
        }
        if (MODE_AOE_LARGE.equals(mode) && this.enableAoeLarge) {
            this.doPlaneAOE(world, player, stack, pos, this.aoeLargeRadius, this.aoeLargeBlockCost);
            return centerOk;
        }
        if (MODE_VEIN_1.equals(mode) && this.enableVein1) {
            this.doVeinMine(world, player, stack, pos, state, this.vein1MaxBlocks, this.vein1MaxDistance, this.vein1BlockCost);
            return centerOk;
        }
        if (MODE_VEIN_2.equals(mode) && this.enableVein2) {
            this.doVeinMine(world, player, stack, pos, state, this.vein2MaxBlocks, this.vein2MaxDistance, this.vein2BlockCost);
            return centerOk;
        }
        return centerOk;
    }

    protected void doPlaneAOE(World world, EntityPlayerMP player, ItemStack stack, BlockPos center, int radius, double costPer) {
        RayTraceResult rt = this.func_77621_a(world, (EntityPlayer)player, false);
        EnumFacing face = rt != null && rt.field_178784_b != null ? rt.field_178784_b : player.func_174811_aO();
        for (BlockPos p : this.getAoEPlane(face, center, radius)) {
            IBlockState st;
            if (p.equals((Object)center) || world.func_175623_d(p) || (st = world.func_180495_p(p)).func_185887_b(world, p) < 0.0f || !st.func_177230_c().canHarvestBlock((IBlockAccess)world, p, (EntityPlayer)player) || this.func_150893_a(stack, st) <= 1.0f) continue;
            if (!this.tryUseEUFromAnySource(stack, (EntityPlayer)player, costPer)) break;
            GameType gt = player.field_71134_c.func_73081_b();
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gt, (EntityPlayerMP)player, (BlockPos)p);
            if (xp < 0) continue;
            st.func_177230_c().func_176208_a(world, p, st, (EntityPlayer)player);
            boolean removed = world.func_175655_b(p, true);
            if (!removed || xp <= 0) continue;
            st.func_177230_c().func_180637_b(world, p, xp);
        }
    }

    protected void doVeinMine(World world, EntityPlayerMP player, ItemStack stack, BlockPos start, IBlockState targetState, int maxBlocks, int maxDistance, double costPer) {
        Block targetBlock = targetState.func_177230_c();
        int targetMeta = targetBlock.func_176201_c(targetState);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos p = (BlockPos)queue.poll();
            if (!visited.add(p)) continue;
            if (!p.equals((Object)start)) {
                IBlockState st;
                if (world.func_175623_d(p) || (st = world.func_180495_p(p)).func_177230_c() != targetBlock || st.func_177230_c().func_176201_c(st) != targetMeta || st.func_185887_b(world, p) < 0.0f || !st.func_177230_c().canHarvestBlock((IBlockAccess)world, p, (EntityPlayer)player) || this.func_150893_a(stack, st) <= 1.0f) continue;
                if (!this.tryUseEUFromAnySource(stack, (EntityPlayer)player, costPer)) break;
                GameType gt = player.field_71134_c.func_73081_b();
                int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gt, (EntityPlayerMP)player, (BlockPos)p);
                if (xp >= 0) {
                    st.func_177230_c().func_176208_a(world, p, st, (EntityPlayer)player);
                    boolean removed = world.func_175655_b(p, true);
                    if (removed && xp > 0) {
                        st.func_177230_c().func_180637_b(world, p, xp);
                    }
                }
            }
            for (EnumFacing f : EnumFacing.values()) {
                IBlockState ns;
                BlockPos n = p.func_177972_a(f);
                if (visited.contains(n) || maxDistance > 0 && (Math.abs(n.func_177958_n() - start.func_177958_n()) > maxDistance || Math.abs(n.func_177956_o() - start.func_177956_o()) > maxDistance || Math.abs(n.func_177952_p() - start.func_177952_p()) > maxDistance) || (ns = world.func_180495_p(n)).func_177230_c() != targetBlock || ns.func_177230_c().func_176201_c(ns) != targetMeta) continue;
                queue.add(n);
            }
        }
    }

    protected List<BlockPos> getAoEPlane(EnumFacing face, BlockPos center, int r) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>((2 * r + 1) * (2 * r + 1));
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                BlockPos bp;
                switch (face) {
                    case UP: 
                    case DOWN: {
                        bp = center.func_177982_a(dx, 0, dy);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        bp = center.func_177982_a(dx, dy, 0);
                        break;
                    }
                    default: {
                        bp = center.func_177982_a(0, dy, dx);
                    }
                }
                out.add(bp);
            }
        }
        return out;
    }
}

