/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.tool.HarvestLevel;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.item.tool.ToolClass;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemAdvancedChainsaw
extends ItemElectricTool {
    private static final String NBT_DISABLE_SHEAR = "disableShear";
    private static final UUID SPEED_MOD = UUID.fromString("8a92cbd6-2351-47b7-9e61-2e0fef7c8c86");
    private static final UUID DAMAGE_MOD = UUID.fromString("2f013b50-4d9e-4ac0-8319-1c6a45d2a4d9");

    public ItemAdvancedChainsaw() {
        super(null, 100, HarvestLevel.Iron, EnumSet.of(ToolClass.Axe, ToolClass.Sword, ToolClass.Shears));
        this.maxCharge = 45000;
        this.transferLimit = 500;
        this.tier = 2;
        this.field_77864_a = 30.0f;
        this.setRegistryName("advanced_chainsaw");
        this.func_77655_b("advanced_chainsaw");
        this.func_77625_d(1);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemInit.ITEMS.add((Item)this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && IC2.keyboard.isModeSwitchKeyDown(player)) {
            ItemStack stack = player.func_184586_b(hand);
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            boolean wasDisabled = nbt.func_74767_n(NBT_DISABLE_SHEAR);
            boolean nowDisabled = !wasDisabled;
            nbt.func_74757_a(NBT_DISABLE_SHEAR, nowDisabled);
            String onOffKey = nowDisabled ? "ic2additions.message.off" : "ic2additions.message.on";
            TextFormatting color = nowDisabled ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN;
            ITextComponent msg = new TextComponentTranslation("ic2additions.advancedChainsaw.shear", new Object[]{new TextComponentTranslation(onOffKey, new Object[0])}).func_150255_a(new Style().func_150238_a(color));
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_145747_a(msg);
            } else {
                player.func_146105_b(msg, true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ElectricItem.manager.use(stack, this.operationEnergyCost, attacker);
        if (attacker instanceof EntityPlayer && target instanceof EntityCreeper && target.func_110143_aJ() <= 0.0f) {
            IC2.achievements.issueAchievement((EntityPlayer)attacker, "killCreeperChainsaw");
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Entity targetEntity = event.getTarget();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return;
        }
        if (!(targetEntity instanceof IShearable)) {
            return;
        }
        if (StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(NBT_DISABLE_SHEAR)) {
            return;
        }
        if (!ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player)) {
            return;
        }
        IShearable shearable = (IShearable)targetEntity;
        BlockPos pos = new BlockPos(targetEntity);
        if (!shearable.isShearable(stack, (IBlockAccess)targetEntity.field_70170_p, pos)) {
            return;
        }
        List drops = shearable.onSheared(stack, (IBlockAccess)targetEntity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
        for (ItemStack drop : drops) {
            EntityItem item = targetEntity.func_70099_a(drop, 1.0f);
            if (item == null) continue;
            item.field_70181_x += (double)(item.field_70170_p.field_73012_v.nextFloat() * 0.05f);
            item.field_70159_w += (double)((item.field_70170_p.field_73012_v.nextFloat() - item.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            item.field_70179_y += (double)((item.field_70170_p.field_73012_v.nextFloat() - item.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return false;
        }
        if (StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(NBT_DISABLE_SHEAR)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof IShearable)) {
            return false;
        }
        IShearable shearable = (IShearable)block;
        if (!shearable.isShearable(stack, (IBlockAccess)world, pos)) {
            return false;
        }
        if (!ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player)) {
            return false;
        }
        List drops = shearable.onSheared(stack, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
        for (ItemStack drop : drops) {
            StackUtil.dropAsEntity((World)world, (BlockPos)pos, (ItemStack)drop);
        }
        player.func_71064_a(StatList.func_188055_a((Block)block), 1);
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean disabled = StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(NBT_DISABLE_SHEAR);
        String state = I18n.func_135052_a((String)(disabled ? "ic2additions.message.off" : "ic2additions.message.on"), (Object[])new Object[0]);
        String line = I18n.func_135052_a((String)"ic2additions.advancedChainsaw.shear", (Object[])new Object[]{state});
        tooltip.add((disabled ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN) + line);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        HashMultimap ret = HashMultimap.create((Multimap)super.getAttributeModifiers(slot, stack));
        if (ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            ret.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(SPEED_MOD, "Tool speed", (double)this.field_185065_c, 0));
            ret.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(DAMAGE_MOD, "Tool damage", 13.0, 0));
        }
        return ret;
    }

    protected String getIdleSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Chainsaw/ChainsawIdle.ogg";
    }

    protected String getStopSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Chainsaw/ChainsawStop.ogg";
    }
}

