/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBarrel;
import ic2.core.init.Localization;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.tool.ItemTreetap;
import ic2.core.ref.BlockName;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultiTool
extends ItemTool
implements IElectricItem {
    private static final double COST_ROTATE = 50.0;
    private static final double COST_HOE = 50.0;
    private static final double COST_TAP = 50.0;
    private static final double COST_SCREW = 500.0;
    private static final double MAX_CHARGE = 300000.0;
    private static final int TIER = 2;
    private static final double TRANSFER = 10000.0;
    private static final String MODID = "ic2additions";
    private static final String TAG_MODE = "toolMode";

    public ItemMultiTool(String name) {
        super(Item.ToolMaterial.IRON, Collections.emptySet());
        this.field_77865_bY = 16.0f;
        this.setRegistryName(MODID, name);
        this.func_77655_b("ic2additions." + name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        this.func_77625_d(1);
        this.func_77656_e(27);
        ItemInit.ITEMS.add((Item)this);
    }

    public static boolean hasMode(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_MODE, 3);
    }

    public static Mode getMode(ItemStack stack) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        return Mode.byId(tag.func_74762_e(TAG_MODE));
    }

    public static void setMode(ItemStack stack, Mode mode) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a(TAG_MODE, mode.ordinal());
    }

    private static Mode nextMode(ItemStack stack) {
        return Mode.byId(ItemMultiTool.getMode(stack).ordinal() + 1);
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemMultiTool.hasMode(stack)) {
            Mode m = ItemMultiTool.getMode(stack);
            return Localization.translate((String)"ic2additions.graviTool.set", (Object[])new Object[]{Localization.translate((String)this.func_77657_g(stack)), Localization.translate((String)m.i18nKey)});
        }
        return Localization.translate((String)this.func_77657_g(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            Mode newMode = Mode.byId(ItemMultiTool.getMode(stack).ordinal() + 1);
            if (world.field_72995_K) {
                ItemMultiTool.setMode(stack, newMode);
                IC2.audioManager.playOnce((Object)player, PositionSpec.Hand, "ic2additions:tool_change", true, IC2.audioManager.getDefaultVolume());
            } else {
                ItemMultiTool.setMode(stack, newMode);
                String msg = Localization.translate((String)"ic2additions.graviTool.changeTool", (Object[])new Object[]{newMode.color + Localization.translate((String)newMode.i18nKey)});
                player.func_145747_a((ITextComponent)new TextComponentString(msg));
                ((EntityPlayerMP)player).field_71069_bz.func_75142_b();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        switch (ItemMultiTool.getMode(stack)) {
            case WRENCH: {
                return this.onUseWrench(stack, player, world, pos, side) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case SCREWDRIVER: {
                return this.onUseScrewdriver(stack, player, world, pos) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (!ItemMultiTool.hasMode(stack)) {
            ItemMultiTool.setMode(stack, Mode.HOE);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        switch (ItemMultiTool.getMode(stack)) {
            case HOE: {
                return this.onUseHoe(stack, player, world, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case TREETAP: {
                return this.onUseTreetap(stack, player, world, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean onUseHoe(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack) || !ItemMultiTool.hasEU(stack, 50.0, player)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return ItemMultiTool.spendEU(stack, 50.0, player, true);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (side != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                return this.setHoed(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
            }
            if (block == Blocks.field_150346_d) {
                BlockDirt.DirtType type = (BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (type == BlockDirt.DirtType.DIRT) {
                    return this.setHoed(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                }
                if (type == BlockDirt.DirtType.COARSE_DIRT) {
                    return this.setHoed(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                }
            }
        }
        return false;
    }

    private boolean setHoed(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        if (!ItemMultiTool.spendEU(stack, 50.0, player, true)) {
            return false;
        }
        world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state, 11);
        }
        return true;
    }

    private boolean onUseTreetap(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (side.func_176740_k() != EnumFacing.Axis.Y && te instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)te;
            if (!barrel.getActive() && ItemMultiTool.spendEU(stack, 50.0, player, true)) {
                if (!world.field_72995_K) {
                    barrel.setActive(true);
                    barrel.onPlaced(stack, null, side.func_176734_d());
                }
                return true;
            }
            return false;
        }
        if (state.func_177230_c() == BlockName.rubber_wood.getInstance() && ItemMultiTool.hasEU(stack, 50.0, player)) {
            boolean ok = ItemTreetap.attemptExtract((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side, (IBlockState)state, null);
            return ok && ItemMultiTool.spendEU(stack, 50.0, player, false);
        }
        return false;
    }

    private boolean onUseWrench(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        if (block instanceof IWrenchable) {
            EnumFacing desired;
            IWrenchable w = (IWrenchable)block;
            EnumFacing current = w.getFacing(world, pos);
            if (IC2.keyboard.isAltKeyDown(player)) {
                EnumFacing.Axis axis = side.func_176740_k();
                boolean forward = !player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE || player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
                desired = forward ? current.func_176732_a(axis) : current.func_176732_a(axis).func_176732_a(axis).func_176732_a(axis);
            } else {
                EnumFacing enumFacing = desired = player.func_70093_af() ? side.func_176734_d() : side;
            }
            if (current != desired) {
                if (!ItemMultiTool.hasEU(stack, 50.0, player)) {
                    return false;
                }
                if (w.setFacing(world, pos, desired, player)) {
                    return ItemMultiTool.spendEU(stack, 50.0, player, false);
                }
            }
            if (w.wrenchCanRemove(world, pos, player)) {
                if (!ItemMultiTool.hasEU(stack, 50.0, player)) {
                    return false;
                }
                if (!world.field_72995_K) {
                    int exp;
                    if (player instanceof EntityPlayerMP) {
                        exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                        if (exp < 0) {
                            return false;
                        }
                    } else {
                        exp = 0;
                    }
                    TileEntity te = world.func_175625_s(pos);
                    block.func_176208_a(world, pos, state, player);
                    if (!block.removedByPlayer(state, world, pos, player, true)) {
                        return false;
                    }
                    block.func_176206_d(world, pos, state);
                    List<ItemStack> drops = w.getWrenchDrops(world, pos, state, te, player, 0);
                    for (ItemStack drop : drops) {
                        StackUtil.dropAsEntity((World)world, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!player.field_71075_bZ.field_75098_d && exp > 0) {
                        block.func_180637_b(world, pos, exp);
                    }
                }
                return ItemMultiTool.spendEU(stack, 50.0, player, false);
            }
        }
        return false;
    }

    private boolean onUseScrewdriver(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        if (!(block instanceof BlockHorizontal)) {
            return false;
        }
        if (!ItemMultiTool.spendEU(stack, 500.0, player, false)) {
            return false;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        facing = player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e();
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
        return true;
    }

    private static boolean hasEU(ItemStack stack, double cost, EntityPlayer player) {
        ElectricItem.manager.chargeFromArmor(stack, (EntityLivingBase)player);
        double probe = ElectricItem.manager.discharge(stack, cost, Integer.MAX_VALUE, true, false, true);
        return Util.isSimilar((double)probe, (double)cost);
    }

    private static boolean spendEU(ItemStack stack, double cost, EntityPlayer player, boolean silent) {
        if (ElectricItem.manager.use(stack, cost, (EntityLivingBase)player)) {
            if (!silent && player.field_70170_p.field_72995_K) {
                IC2.audioManager.playOnce((Object)player, PositionSpec.Hand, "ic2additions:wrench", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        IC2.platform.messagePlayer(player, Localization.translate((String)"ic2additions.graviTool.noEnergy"), new Object[0]);
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return HashMultimap.create();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ElectricItemManager.addChargeVariants((Item)this, items);
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 300000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 10000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                Mode m = ItemMultiTool.hasMode(stack) ? ItemMultiTool.getMode(stack) : Mode.HOE;
                return m.model;
            }
        });
        for (Mode m : Mode.values()) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{m.model});
        }
    }

    public static enum Mode {
        HOE(TextFormatting.DARK_GREEN),
        TREETAP(TextFormatting.GOLD),
        WRENCH(TextFormatting.AQUA),
        SCREWDRIVER(TextFormatting.LIGHT_PURPLE);

        public final TextFormatting color;
        public final String i18nKey;
        public final ModelResourceLocation model;

        private Mode(TextFormatting color) {
            this.color = color;
            this.i18nKey = "ic2additions.graviTool." + this.name().toLowerCase(Locale.ENGLISH);
            this.model = new ModelResourceLocation("ic2additions:gravitool/" + this.name().toLowerCase(Locale.ENGLISH), null);
        }

        public static Mode byId(int id) {
            Mode[] vals = Mode.values();
            return vals[Math.floorMod(id, vals.length)];
        }
    }
}

