/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.util.ActivatableItem;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.item.tool.HarvestLevel;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.item.tool.ToolClass;
import ic2.core.slot.ArmorSlot;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuantumSaber
extends ItemElectricTool
implements ActivatableItem {
    public static int ticker = 0;
    private int soundTicker = 0;

    public ItemQuantumSaber() {
        super(null, 10, HarvestLevel.Diamond, EnumSet.of(ToolClass.Sword));
        this.maxCharge = 1000000;
        this.transferLimit = 30000;
        this.tier = 3;
        this.setRegistryName("quantum_saber");
        this.func_77655_b("quantum_saber");
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        ItemInit.ITEMS.add((Item)this);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isActive(stack)) {
            ++this.soundTicker;
            if (IC2.platform.isRendering() && this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return state.func_177230_c() == Blocks.field_150321_G ? 50.0f : 4.0f;
        }
        return 1.0f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        int dmg = 7;
        if (ElectricItem.manager.canUse(stack, 400.0) && this.isActive(stack)) {
            dmg = 55;
        }
        HashMultimap ret = HashMultimap.create();
        ret.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        ret.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", (double)dmg, 0));
        return ret;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase source) {
        if (!this.isActive(stack)) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            ItemQuantumSaber.drainSaber(stack, 400.0, source);
            if (!(source instanceof EntityPlayerMP) || !(target instanceof EntityPlayer) || ((EntityPlayerMP)source).func_96122_a((EntityPlayer)target)) {
                for (EntityEquipmentSlot slot : ArmorSlot.getAll()) {
                    if (!ElectricItem.manager.canUse(stack, 2000.0)) break;
                    ItemStack armor = target.func_184582_a(slot);
                    if (armor == null) continue;
                    double amount = 0.0;
                    if (armor.func_77973_b().getRegistryName().toString().contains("nano")) {
                        amount = 48000.0;
                    } else if (armor.func_77973_b().getRegistryName().toString().contains("quantum")) {
                        amount = 300000.0;
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.func_184201_a(slot, (ItemStack)null);
                    }
                    ItemQuantumSaber.drainSaber(stack, 2000.0, source);
                }
            }
        }
        if (IC2.platform.isRendering()) {
            IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            case 1: {
                return "Tools/Nanosabre/NanosabreSwing2.ogg";
            }
            case 2: {
                return "Tools/Nanosabre/NanosabreSwing3.ogg";
            }
        }
        return "Tools/Nanosabre/NanosabreSwing1.ogg";
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (this.isActive(stack)) {
            ItemQuantumSaber.drainSaber(stack, 80.0, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public static void drainSaber(ItemStack stack, double amount, EntityLivingBase entity) {
        if (!ElectricItem.manager.use(stack, amount, entity)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            ItemQuantumSaber.setActive(nbt, false);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (ItemQuantumSaber.isActive(nbt)) {
            ItemQuantumSaber.setActive(nbt, false);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (ElectricItem.manager.canUse(stack, 16.0)) {
            ItemQuantumSaber.setActive(nbt, true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean par5) {
        super.func_77663_a(stack, world, entity, slot, par5 && this.isActive(stack));
        if (this.isActive(stack) && ticker % 16 == 0 && entity instanceof EntityPlayerMP) {
            if (slot < 9) {
                ItemQuantumSaber.drainSaber(stack, 64.0, (EntityLivingBase)((EntityPlayer)entity));
            } else if (ticker % 64 == 0) {
                ItemQuantumSaber.drainSaber(stack, 16.0, (EntityLivingBase)((EntityPlayer)entity));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public boolean isActive(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("active");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerClientProperty() {
        this.func_185043_a(new ResourceLocation("ic2additions", "active"), (stack, world, entity) -> this.isActive(stack) ? 1.0f : 0.0f);
    }

    private static boolean isActive(NBTTagCompound nbt) {
        return nbt.func_74767_n("active");
    }

    private static void setActive(NBTTagCompound nbt, boolean active) {
        nbt.func_74757_a("active", active);
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        if (IC2.platform.isRendering() && this.isActive(stack)) {
            IC2.audioManager.playOnce((Object)entity, PositionSpec.Hand, this.getRandomSwingSound(), true, IC2.audioManager.getDefaultVolume());
        }
        return false;
    }

    protected String getIdleSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Nanosabre/NanosabreIdle.ogg";
    }

    protected String getStartSound(EntityLivingBase player, ItemStack stack) {
        return "Tools/Nanosabre/NanosabrePowerup.ogg";
    }
}

