/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.network.GuiSynced;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BaseSolarPanel
extends TileEntityBaseGenerator {
    private final double euAtFullSun;
    private int tickCounter = 0;
    @GuiSynced
    public float skyLight;

    public BaseSolarPanel(double euAtFullSun, int tier, int storage) {
        super(0.0, tier, storage);
        this.euAtFullSun = euAtFullSun;
    }

    protected void onLoaded() {
        super.onLoaded();
        this.updateSunVisibility();
    }

    public boolean gainEnergy() {
        if (++this.tickCounter % 128 == 0) {
            this.updateSunVisibility();
        }
        if (this.skyLight > 0.0f) {
            this.energy.addEnergy(this.euAtFullSun * (double)this.skyLight);
            return true;
        }
        return false;
    }

    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.skyLight = TileEntitySolarGenerator.getSkyLight((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177984_a());
    }

    public boolean needsFuel() {
        return false;
    }

    protected boolean delayActiveUpdate() {
        return true;
    }

    public boolean getGuiState(String name) {
        if ("sunlight".equals(name)) {
            return this.skyLight > 0.0f;
        }
        return super.getGuiState(name);
    }

    public double getEutNow() {
        double raw = this.euAtFullSun * (double)this.skyLight;
        return (double)Math.round(raw * 10.0) / 10.0;
    }
}

