/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.util;

import ic2.core.IC2;
import ic2.core.util.Keyboard;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class IC2AdditionsKeys
extends Keyboard {
    private static final Keyboard.IKeyWatcher FLY_KEY = new KeyWatcher(ic2Additionskeys.FLY);
    private static final Keyboard.IKeyWatcher HOVER_KEY = new KeyWatcher(ic2Additionskeys.HOVER);

    private IC2AdditionsKeys() {
    }

    public static void register() {
        IC2.keyboard.addKeyWatcher(FLY_KEY);
        IC2.keyboard.addKeyWatcher(HOVER_KEY);
    }

    public static boolean isFlyKeyDown(EntityPlayer player) {
        return IC2.keyboard.isKeyDown(player, FLY_KEY);
    }

    public static boolean isHoverKeyDown(EntityPlayer player) {
        return IC2.keyboard.isKeyDown(player, HOVER_KEY);
    }

    private static enum ic2Additionskeys {
        FLY(33, "Fly"),
        HOVER(35, "Hover");

        private final Keyboard.Key key = ic2Additionskeys.addKey(this.name());
        @SideOnly(value=Side.CLIENT)
        private KeyBinding binding;

        private ic2Additionskeys(int defaultKey, String desc) {
            if (IC2.platform.isRendering()) {
                String cat = "IC2Additions".substring(0, 1).toUpperCase(Locale.ENGLISH) + "IC2Additions".substring(1);
                this.binding = new KeyBinding(desc, defaultKey, cat);
                ClientRegistry.registerKeyBinding((KeyBinding)this.binding);
            }
        }

        private static Field keysField() {
            try {
                Field f = ReflectionUtil.getField(Keyboard.Key.class, (String[])new String[]{"keys"});
                ReflectionUtil.getField(Field.class, (String[])new String[]{"modifiers"}).setInt(f, f.getModifiers() & 0xFFFFFFEF);
                return f;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to reflect IC2 Keyboard.Key.keys", e);
            }
        }

        private static Keyboard.Key addKey(String name) {
            Keyboard.Key key = (Keyboard.Key)EnumHelper.addEnum(Keyboard.Key.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
            ReflectionUtil.setValue(null, (Field)ic2Additionskeys.keysField(), (Object)ArrayUtils.add((Object[])Keyboard.Key.keys, (Object)key));
            return key;
        }
    }

    private static class KeyWatcher
    implements Keyboard.IKeyWatcher {
        private final ic2Additionskeys key;

        KeyWatcher(ic2Additionskeys key) {
            this.key = key;
        }

        public Keyboard.Key getRepresentation() {
            return this.key.key;
        }

        @SideOnly(value=Side.CLIENT)
        public void checkForKey(Set<Keyboard.Key> pressed) {
            if (GameSettings.func_100015_a((KeyBinding)this.key.binding)) {
                pressed.add(this.getRepresentation());
            }
        }
    }
}

