/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public final class Config {
    public boolean enabled = true;
    public String discordLink = "https://discord.gg/A2Nx9kxDeB";
    public Group endCrystal = Group.make(true);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("!!!crystal_anchor_models.json");
    private static Config INSTANCE;

    public static Config get() {
        if (INSTANCE == null) {
            Config.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (Files.exists(FILE, new LinkOption[0])) {
                INSTANCE = (Config)GSON.fromJson(Files.readString(FILE), Config.class);
            } else {
                INSTANCE = new Config();
                Config.save();
            }
        }
        catch (Exception e) {
            INSTANCE = new Config();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)INSTANCE), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class Group {
        public boolean enabled = true;
        public String selectedModel = "";
        public boolean hideVanilla = true;
        public Map<String, ModelSettings> perModel = new HashMap<String, ModelSettings>();
        public boolean performanceMode = false;
        public Perf perf = new Perf();
        public boolean hover = true;
        public boolean spin = true;
        public boolean spin3d = true;
        public boolean randomStartRotation = true;
        public boolean continueRotationFromLast = false;
        public boolean dualEnabled = false;
        public String secondaryModel = "";
        public Map<String, ModelSettings> secondaryPerModel = new HashMap<String, ModelSettings>();
        public boolean secondaryMatchRotation = true;
        public boolean secondarySpin3dFollowPrimary = true;
        public boolean secondarySpin3d = false;
        private boolean crystalDefaults;

        private static Group make(boolean crystal) {
            Group g = new Group();
            g.crystalDefaults = crystal;
            return g;
        }

        public ModelSettings getSelected(List<String> available) {
            if ((this.selectedModel == null || this.selectedModel.isEmpty() || available != null && !available.isEmpty() && !available.contains(this.selectedModel)) && available != null && !available.isEmpty()) {
                String prefer = null;
                for (String s : available) {
                    if (!"fpsrubix".equalsIgnoreCase(s)) continue;
                    prefer = s;
                    break;
                }
                this.selectedModel = prefer != null ? prefer : available.get(0);
            }
            ModelSettings m = this.perModel.computeIfAbsent(this.selectedModel == null ? "" : this.selectedModel, k -> {
                ModelSettings ms = new ModelSettings();
                if (this.crystalDefaults && ms.offset[1] == 0.0f) {
                    ms.offset[1] = 0.7f;
                }
                return ms;
            });
            if (this.crystalDefaults && m.offset[1] == 0.0f) {
                m.offset[1] = 0.7f;
            }
            return m;
        }

        public ModelSettings getSecondary(String baseOverride, List<String> available) {
            if (this.secondaryModel == null || this.secondaryModel.isEmpty() || available != null && !available.isEmpty() && !available.contains(this.secondaryModel)) {
                if (baseOverride != null && !baseOverride.isEmpty()) {
                    this.secondaryModel = baseOverride;
                } else if (available != null && !available.isEmpty()) {
                    this.secondaryModel = available.get(0);
                }
            }
            return this.secondaryPerModel.computeIfAbsent(this.secondaryModel == null ? "" : this.secondaryModel, k -> {
                ModelSettings ms = new ModelSettings();
                if (this.crystalDefaults && ms.offset[1] == 0.0f) {
                    ms.offset[1] = 0.7f;
                }
                return ms;
            });
        }
    }

    public static final class Perf {
        public boolean useVbo = true;
        public boolean shaderAnimation = false;
        public boolean registryTracking = true;
        public boolean idleSkip = true;
        public boolean frustumCulling = true;
        public boolean distanceCulling = false;
        public float maxDistance = 64.0f;
        public boolean batchByTexture = true;
        public boolean useOpaqueLayer = false;
        public int tickDecimation = 1;
    }

    public static final class ModelSettings {
        public float scale = 0.7f;
        public float[] offset = new float[]{0.0f, 0.7f, 0.0f};
        public float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
    }
}

