/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.mixin;

import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import me.cutebow.crystal_anchor_models.config.Config;
import me.cutebow.crystal_anchor_models.model.ObjLoader;
import me.cutebow.crystal_anchor_models.model.ObjMesh;
import me.cutebow.crystal_anchor_models.render.ObjRenderer;
import me.cutebow.crystal_anchor_models.util.AssetScanner;
import net.minecraft.class_1511;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_892;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_892.class})
public abstract class EndCrystalEntityRendererMixin {
    private static final WeakHashMap<Integer, float[]> SEED_CACHE = new WeakHashMap();
    private static long cacheTick = Long.MIN_VALUE;
    private static int cachedNewestId = Integer.MIN_VALUE;

    private static float[] seed(int id, int salt) {
        long s = (long)id << 1 ^ -7046029254386353131L * (long)salt;
        Random r = new Random(s);
        return new float[]{r.nextFloat() * 360.0f, r.nextFloat() * 360.0f, r.nextFloat() * 360.0f};
    }

    private static float[] getSeedFor(int id) {
        float[] s = SEED_CACHE.get(id);
        if (s == null) {
            s = EndCrystalEntityRendererMixin.seed(id, 0);
            SEED_CACHE.put(id, s);
        }
        return s;
    }

    private static void updateNewestCrystalIdIfNeeded(float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        long t = mc.field_1687.method_8510();
        if (t == cacheTick) {
            return;
        }
        cacheTick = t;
        cachedNewestId = Integer.MIN_VALUE;
        double r = 128.0;
        Config cfg = Config.get();
        if (cfg.endCrystal.perf.distanceCulling) {
            r = Math.max(2.0, (double)cfg.endCrystal.perf.maxDistance);
        }
        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_238 box = new class_238(cam.field_1352 - r, cam.field_1351 - r, cam.field_1350 - r, cam.field_1352 + r, cam.field_1351 + r, cam.field_1350 + r);
        List list = mc.field_1687.method_8390(class_1511.class, box, e -> true);
        for (class_1511 e2 : list) {
            if (e2.method_5628() <= cachedNewestId) continue;
            cachedNewestId = e2.method_5628();
        }
    }

    @Inject(method={"method_3908(Lnet/minecraft/class_1511;FFLnet/minecraft/class_4587;Lnet/minecraft/class_4597;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cam$replace(class_1511 entity, float yawUnused, float tickDelta, class_4587 matrices, class_4597 vertices, int light, CallbackInfo ci) {
        ObjMesh mesh2;
        String base2;
        float[] fArray;
        float rollSpin1;
        Config cfg = Config.get();
        if (!cfg.enabled || !cfg.endCrystal.enabled) {
            return;
        }
        if (cfg.endCrystal.performanceMode) {
            EndCrystalEntityRendererMixin.updateNewestCrystalIdIfNeeded(tickDelta);
            if (entity.method_5628() != cachedNewestId) {
                return;
            }
        }
        List<String> models = AssetScanner.getCrystalModels();
        Config.ModelSettings sel1 = cfg.endCrystal.getSelected(models);
        String base1 = cfg.endCrystal.selectedModel;
        if (base1 == null || base1.isEmpty() || sel1 == null) {
            if (cfg.endCrystal.hideVanilla && (!cfg.endCrystal.performanceMode || entity.method_5628() == cachedNewestId)) {
                ci.cancel();
            }
            return;
        }
        ObjMesh mesh1 = ObjLoader.load(base1);
        if (mesh1 == null) {
            if (cfg.endCrystal.hideVanilla && (!cfg.endCrystal.performanceMode || entity.method_5628() == cachedNewestId)) {
                ci.cancel();
            }
            return;
        }
        class_310 mc = class_310.method_1551();
        float timeBase = cfg.endCrystal.continueRotationFromLast && mc.field_1687 != null ? (float)mc.field_1687.method_8510() + tickDelta : (float)entity.field_6012 + tickDelta;
        float bob = cfg.endCrystal.hover ? class_3532.method_15374((float)(timeBase * 0.2f)) * 0.1f : 0.0f;
        float yawSpin1 = cfg.endCrystal.spin ? timeBase : 0.0f;
        float pitchSpin1 = cfg.endCrystal.spin3d ? timeBase * 0.73f : 0.0f;
        float f = rollSpin1 = cfg.endCrystal.spin3d ? timeBase * 1.17f : 0.0f;
        if (cfg.endCrystal.randomStartRotation) {
            fArray = EndCrystalEntityRendererMixin.getSeedFor(entity.method_5628());
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray = fArray2;
            fArray2[2] = 0.0f;
        }
        float[] rand1 = fArray;
        float pitch1 = sel1.rotation[0] + rand1[0] + pitchSpin1;
        float yaw1 = sel1.rotation[1] + rand1[1] + yawSpin1;
        float roll1 = sel1.rotation[2] + rand1[2] + rollSpin1;
        class_2960 tex1 = class_2960.method_60655((String)"crystal_anchor_models", (String)("textures/models/" + base1 + ".png"));
        matrices.method_22903();
        ObjRenderer.render(mesh1, tex1, matrices, vertices, light, sel1.scale, sel1.offset[0], sel1.offset[1] + bob, sel1.offset[2], yaw1, pitch1, roll1);
        matrices.method_22909();
        if (cfg.endCrystal.dualEnabled && (base2 = cfg.endCrystal.secondaryModel) != null && !base2.isEmpty() && (mesh2 = ObjLoader.load(base2)) != null) {
            float rollSpin2;
            float pitchSpin2;
            float yawSpin2;
            float[] fArray3;
            float rollBase2;
            Config.ModelSettings sel2 = cfg.endCrystal.getSecondary(base2, models);
            float yawBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[1] : sel2.rotation[1];
            float pitchBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[0] : sel2.rotation[0];
            float f2 = rollBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[2] : sel2.rotation[2];
            if (cfg.endCrystal.randomStartRotation) {
                fArray3 = EndCrystalEntityRendererMixin.seed(entity.method_5628(), 1);
            } else {
                float[] fArray4 = new float[3];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.0f;
                fArray3 = fArray4;
                fArray4[2] = 0.0f;
            }
            float[] rand2 = fArray3;
            float f3 = yawSpin2 = cfg.endCrystal.spin ? timeBase : 0.0f;
            if (cfg.endCrystal.secondarySpin3dFollowPrimary) {
                pitchSpin2 = pitchSpin1;
                rollSpin2 = rollSpin1;
            } else {
                pitchSpin2 = cfg.endCrystal.secondarySpin3d ? timeBase * 0.73f : 0.0f;
                rollSpin2 = cfg.endCrystal.secondarySpin3d ? timeBase * 1.17f : 0.0f;
            }
            float pitch2 = pitchBase2 + rand2[0] + pitchSpin2;
            float yaw2 = yawBase2 + rand2[1] + yawSpin2;
            float roll2 = rollBase2 + rand2[2] + rollSpin2;
            class_2960 tex2 = class_2960.method_60655((String)"crystal_anchor_models", (String)("textures/models/" + base2 + ".png"));
            matrices.method_22903();
            ObjRenderer.render(mesh2, tex2, matrices, vertices, light, sel2.scale, sel2.offset[0], sel2.offset[1] + bob, sel2.offset[2], yaw2, pitch2, roll2);
            matrices.method_22909();
        }
        if (cfg.endCrystal.hideVanilla) {
            ci.cancel();
        }
    }
}

