/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.mixin;

import java.util.List;
import java.util.Random;
import me.cutebow.crystal_anchor_models.config.Config;
import me.cutebow.crystal_anchor_models.model.ObjLoader;
import me.cutebow.crystal_anchor_models.model.ObjMesh;
import me.cutebow.crystal_anchor_models.render.ObjRenderer;
import me.cutebow.crystal_anchor_models.state.SeededAngles;
import me.cutebow.crystal_anchor_models.util.AssetScanner;
import net.minecraft.class_10014;
import net.minecraft.class_1511;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_892;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_892.class})
public abstract class EndCrystalEntityRendererMixin {
    @Unique
    private static long cam$cacheTick = Long.MIN_VALUE;
    @Unique
    private static int cam$newestId = Integer.MIN_VALUE;

    @Unique
    private static float[] cam$seed(int id, int salt) {
        long s = (long)id << 1 ^ -7046029254386353131L * (long)salt;
        Random r = new Random(s);
        return new float[]{r.nextFloat() * 360.0f, r.nextFloat() * 360.0f, r.nextFloat() * 360.0f};
    }

    @Unique
    private static void cam$updateNewest(float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        long t = mc.field_1687.method_8510();
        if (t == cam$cacheTick) {
            return;
        }
        cam$cacheTick = t;
        cam$newestId = Integer.MIN_VALUE;
        double r = 128.0;
        Config cfg = Config.get();
        if (cfg.endCrystal.perf.distanceCulling) {
            r = Math.max(2.0, (double)cfg.endCrystal.perf.maxDistance);
        }
        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_238 box = new class_238(cam.field_1352 - r, cam.field_1351 - r, cam.field_1350 - r, cam.field_1352 + r, cam.field_1351 + r, cam.field_1350 + r);
        List list = mc.field_1687.method_8390(class_1511.class, box, e -> true);
        for (class_1511 e2 : list) {
            if (e2.method_5628() <= cam$newestId) continue;
            cam$newestId = e2.method_5628();
        }
    }

    @Inject(method={"method_62417(Lnet/minecraft/class_1511;Lnet/minecraft/class_10014;F)V"}, at={@At(value="TAIL")})
    private void cam$updateState(class_1511 entity, class_10014 state, float tickDelta, CallbackInfo ci) {
        Config cfg = Config.get();
        SeededAngles sa = (SeededAngles)state;
        class_310 mc = class_310.method_1551();
        float timeBase = cfg.endCrystal.continueRotationFromLast && mc.field_1687 != null ? (float)mc.field_1687.method_8510() + tickDelta : (float)entity.field_6012 + tickDelta;
        sa.cam$setTimeBase(timeBase);
        if (cfg.endCrystal.randomStartRotation) {
            float[] p = EndCrystalEntityRendererMixin.cam$seed(entity.method_5628(), 0);
            float[] s = EndCrystalEntityRendererMixin.cam$seed(entity.method_5628(), 1);
            sa.cam$setPrimarySeed(p[1], p[0], p[2]);
            sa.cam$setSecondarySeed(s[1], s[0], s[2]);
        } else {
            sa.cam$setPrimarySeed(0.0f, 0.0f, 0.0f);
            sa.cam$setSecondarySeed(0.0f, 0.0f, 0.0f);
        }
        EndCrystalEntityRendererMixin.cam$updateNewest(tickDelta);
        sa.cam$setIsNewest(entity.method_5628() == cam$newestId);
    }

    @Inject(method={"method_3908(Lnet/minecraft/class_10014;Lnet/minecraft/class_4587;Lnet/minecraft/class_4597;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cam$render(class_10014 state, class_4587 matrices, class_4597 vertices, int light, CallbackInfo ci) {
        ObjMesh mesh2;
        String base2;
        Config cfg = Config.get();
        if (!cfg.enabled || !cfg.endCrystal.enabled) {
            return;
        }
        SeededAngles sa = (SeededAngles)state;
        if (cfg.endCrystal.performanceMode && !sa.cam$isNewest()) {
            return;
        }
        List<String> models = AssetScanner.getCrystalModels();
        Config.ModelSettings sel1 = cfg.endCrystal.getSelected(models);
        String base1 = cfg.endCrystal.selectedModel;
        if (base1 == null || base1.isEmpty() || sel1 == null) {
            if (cfg.endCrystal.hideVanilla && (!cfg.endCrystal.performanceMode || sa.cam$isNewest())) {
                ci.cancel();
            }
            return;
        }
        ObjMesh mesh1 = ObjLoader.load(base1);
        if (mesh1 == null) {
            if (cfg.endCrystal.hideVanilla && (!cfg.endCrystal.performanceMode || sa.cam$isNewest())) {
                ci.cancel();
            }
            return;
        }
        float timeBase = sa.cam$getTimeBase();
        float bob = cfg.endCrystal.hover ? class_3532.method_15374((float)(timeBase * 0.2f)) * 0.1f : 0.0f;
        boolean spin3d = cfg.endCrystal.spin3d;
        float yawSpin1 = cfg.endCrystal.spin ? timeBase : 0.0f;
        float pitchSpin1 = spin3d ? timeBase * 0.73f : 0.0f;
        float rollSpin1 = spin3d ? timeBase * 1.17f : 0.0f;
        float pitch1 = sel1.rotation[0] + sa.cam$getPrimaryPitch() + pitchSpin1;
        float yaw1 = sel1.rotation[1] + sa.cam$getPrimaryYaw() + yawSpin1;
        float roll1 = sel1.rotation[2] + sa.cam$getPrimaryRoll() + rollSpin1;
        class_2960 tex1 = class_2960.method_60655((String)"crystal_anchor_models", (String)("textures/models/" + base1 + ".png"));
        matrices.method_22903();
        ObjRenderer.render(mesh1, tex1, matrices, vertices, light, sel1.scale, sel1.offset[0], sel1.offset[1] + bob, sel1.offset[2], yaw1, pitch1, roll1);
        matrices.method_22909();
        if (cfg.endCrystal.dualEnabled && (base2 = cfg.endCrystal.secondaryModel) != null && !base2.isEmpty() && (mesh2 = ObjLoader.load(base2)) != null) {
            float pitchSpin2;
            boolean spin3d2;
            Config.ModelSettings sel2 = cfg.endCrystal.getSecondary(base2, models);
            float yawBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[1] : sel2.rotation[1];
            float pitchBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[0] : sel2.rotation[0];
            float rollBase2 = cfg.endCrystal.secondaryMatchRotation ? sel1.rotation[2] : sel2.rotation[2];
            float yawSpin2 = cfg.endCrystal.spin ? timeBase : 0.0f;
            boolean bl = spin3d2 = cfg.endCrystal.secondarySpin3dFollowPrimary || cfg.endCrystal.secondarySpin3d || spin3d;
            float f = spin3d2 ? (cfg.endCrystal.secondarySpin3dFollowPrimary ? pitchSpin1 : timeBase * 0.73f) : (pitchSpin2 = 0.0f);
            float rollSpin2 = spin3d2 ? (cfg.endCrystal.secondarySpin3dFollowPrimary ? rollSpin1 : timeBase * 1.17f) : 0.0f;
            float pitch2 = pitchBase2 + sa.cam$getSecondaryPitch() + pitchSpin2;
            float yaw2 = yawBase2 + sa.cam$getSecondaryYaw() + yawSpin2;
            float roll2 = rollBase2 + sa.cam$getSecondaryRoll() + rollSpin2;
            class_2960 tex2 = class_2960.method_60655((String)"crystal_anchor_models", (String)("textures/models/" + base2 + ".png"));
            matrices.method_22903();
            ObjRenderer.render(mesh2, tex2, matrices, vertices, light, sel2.scale, sel2.offset[0], sel2.offset[1] + bob, sel2.offset[2], yaw2, pitch2, roll2);
            matrices.method_22909();
        }
        if (cfg.endCrystal.hideVanilla) {
            ci.cancel();
        }
    }
}

