/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.model;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.cutebow.crystal_anchor_models.model.ObjMesh;
import me.cutebow.crystal_anchor_models.util.AssetScanner;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public final class ObjLoader {
    private static final Map<String, ObjMesh> CACHE = new HashMap<String, ObjMesh>();

    private ObjLoader() {
    }

    public static ObjMesh load(String base) {
        return CACHE.computeIfAbsent(base, ObjLoader::read);
    }

    private static ObjMesh read(String base) {
        try {
            BufferedReader br = ObjLoader.openReader(base);
            if (br == null) {
                return null;
            }
            ArrayList<float[]> verts = new ArrayList<float[]>();
            ArrayList<float[]> texs = new ArrayList<float[]>();
            ArrayList<int[]> faces = new ArrayList<int[]>();
            try (BufferedReader in = br;){
                String line;
                while ((line = in.readLine()) != null) {
                    String[] p;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    if (line.startsWith("v ")) {
                        p = line.split("\\s+");
                        verts.add(new float[]{Float.parseFloat(p[1]), Float.parseFloat(p[2]), Float.parseFloat(p[3])});
                        continue;
                    }
                    if (line.startsWith("vt ")) {
                        p = line.split("\\s+");
                        texs.add(new float[]{Float.parseFloat(p[1]), 1.0f - Float.parseFloat(p[2])});
                        continue;
                    }
                    if (!line.startsWith("f ")) continue;
                    p = line.substring(2).trim().split("\\s+");
                    if (p.length == 3) {
                        faces.add(ObjLoader.parseFace(p[0]));
                        faces.add(ObjLoader.parseFace(p[1]));
                        faces.add(ObjLoader.parseFace(p[2]));
                        continue;
                    }
                    if (p.length != 4) continue;
                    faces.add(ObjLoader.parseFace(p[0]));
                    faces.add(ObjLoader.parseFace(p[1]));
                    faces.add(ObjLoader.parseFace(p[2]));
                    faces.add(ObjLoader.parseFace(p[0]));
                    faces.add(ObjLoader.parseFace(p[2]));
                    faces.add(ObjLoader.parseFace(p[3]));
                }
            }
            int vCount = faces.size();
            float[] positions = new float[vCount * 3];
            float[] uvs = new float[vCount * 2];
            int[] indices = new int[vCount];
            for (int i = 0; i < faces.size(); ++i) {
                float[] fArray;
                int[] idx = (int[])faces.get(i);
                float[] v = (float[])verts.get(idx[0]);
                if (idx[1] >= 0 && idx[1] < texs.size()) {
                    fArray = (float[])texs.get(idx[1]);
                } else {
                    float[] fArray2 = new float[2];
                    fArray2[0] = 0.0f;
                    fArray = fArray2;
                    fArray2[1] = 0.0f;
                }
                float[] t = fArray;
                positions[i * 3] = v[0];
                positions[i * 3 + 1] = v[1];
                positions[i * 3 + 2] = v[2];
                uvs[i * 2] = t[0];
                uvs[i * 2 + 1] = t[1];
                indices[i] = i;
            }
            return new ObjMesh(positions, uvs, indices);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static BufferedReader openReader(String base) {
        try {
            class_2960 objId = class_2960.method_60655((String)"crystal_anchor_models", (String)("models/custom/" + base + ".obj"));
            Optional res = class_310.method_1551().method_1478().method_14486(objId);
            if (res.isPresent()) {
                return new BufferedReader(new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8));
            }
        }
        catch (Exception objId) {
            // empty catch block
        }
        try {
            Path p = AssetScanner.getUserModelsDir().resolve(base + ".obj");
            if (Files.exists(p, new LinkOption[0])) {
                return Files.newBufferedReader(p, StandardCharsets.UTF_8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static int[] parseFace(String token) {
        String[] parts = token.split("/");
        int vi = Integer.parseInt(parts[0]) - 1;
        int ti = parts.length > 1 && !parts[1].isEmpty() ? Integer.parseInt(parts[1]) - 1 : -1;
        return new int[]{vi, ti};
    }
}

