/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.render;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.cutebow.crystal_anchor_models.model.ObjMesh;
import me.cutebow.crystal_anchor_models.util.AssetScanner;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;

public final class ObjRenderer {
    private static final Map<String, class_2960> DYN_IDS = new HashMap<String, class_2960>();
    private static final Map<String, class_1043> DYN_TEX = new HashMap<String, class_1043>();

    private ObjRenderer() {
    }

    public static void clearDynamic() {
        class_1060 tm = class_310.method_1551().method_1531();
        for (Map.Entry<String, class_1043> e : DYN_TEX.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            tm.method_4615(DYN_IDS.get(e.getKey()));
        }
        DYN_IDS.clear();
        DYN_TEX.clear();
    }

    public static void render(ObjMesh mesh, class_2960 texture, class_4587 matrices, class_4597 provider, int light, float scale, float ox, float oy, float oz, float yaw, float pitch, float roll) {
        class_2960 resolved = ObjRenderer.resolveTexture(texture);
        class_4588 vc = provider.getBuffer(class_1921.method_23580((class_2960)resolved));
        matrices.method_22903();
        matrices.method_46416(ox, oy, oz);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(yaw));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(pitch));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(roll));
        class_4587.class_4665 entry = matrices.method_23760();
        int i = 0;
        while (i + 2 < mesh.indices.length) {
            int ia = mesh.indices[i];
            int ib = mesh.indices[i + 1];
            int ic = mesh.indices[i + 2];
            float ax = mesh.positions[ia * 3];
            float ay = mesh.positions[ia * 3 + 1];
            float az = mesh.positions[ia * 3 + 2];
            float au = mesh.uvs[ia * 2];
            float av = mesh.uvs[ia * 2 + 1];
            float bx = mesh.positions[ib * 3];
            float by = mesh.positions[ib * 3 + 1];
            float bz = mesh.positions[ib * 3 + 2];
            float bu = mesh.uvs[ib * 2];
            float bv = mesh.uvs[ib * 2 + 1];
            float cx = mesh.positions[ic * 3];
            float cy = mesh.positions[ic * 3 + 1];
            float cz = mesh.positions[ic * 3 + 2];
            float cu = mesh.uvs[ic * 2];
            float cv = mesh.uvs[ic * 2 + 1];
            float uy = by - ay;
            float vz = cz - az;
            float uz = bz - az;
            float vy = cy - ay;
            float nx = uy * vz - uz * vy;
            float vx = cx - ax;
            float ux = bx - ax;
            float ny = uz * vx - ux * vz;
            float nz = ux * vy - uy * vx;
            float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (len != 0.0f) {
                nx /= len;
                ny /= len;
                nz /= len;
            }
            ObjRenderer.emit(vc, entry, ax, ay, az, au, av, nx, ny, nz, light);
            ObjRenderer.emit(vc, entry, bx, by, bz, bu, bv, nx, ny, nz, light);
            ObjRenderer.emit(vc, entry, cx, cy, cz, cu, cv, nx, ny, nz, light);
            ObjRenderer.emit(vc, entry, cx, cy, cz, cu, cv, nx, ny, nz, light);
            i += 3;
        }
        matrices.method_22909();
    }

    private static class_2960 resolveTexture(class_2960 id) {
        class_2960 class_29602;
        block13: {
            String base;
            try {
                Optional res = class_310.method_1551().method_1478().method_14486(id);
                if (res.isPresent()) {
                    return id;
                }
            }
            catch (Exception res) {
                // empty catch block
            }
            String path = id.method_12832();
            int s = path.lastIndexOf(47);
            int d = path.lastIndexOf(46);
            String string = base = d > s && d > -1 ? path.substring(s + 1, d) : path.substring(s + 1);
            if (DYN_IDS.containsKey(base)) {
                return DYN_IDS.get(base);
            }
            Path file = AssetScanner.getUserModelsDir().resolve(base + ".png");
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return id;
            }
            class_2960 dyn = class_2960.method_60655((String)"crystal_models", (String)("dyn/" + base));
            InputStream in = Files.newInputStream(file, new OpenOption[0]);
            try {
                class_1011 img = class_1011.method_4309((InputStream)in);
                class_1043 tex = new class_1043(img);
                class_310.method_1551().method_1531().method_4616(dyn, (class_1044)tex);
                DYN_IDS.put(base, dyn);
                DYN_TEX.put(base, tex);
                class_29602 = dyn;
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return id;
                }
            }
            in.close();
        }
        return class_29602;
    }

    private static void emit(class_4588 vc, class_4587.class_4665 entry, float x, float y, float z, float u, float v, float nx, float ny, float nz, int light) {
        vc.method_56824(entry, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, nx, ny, nz);
    }
}

