/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystal_anchor_models.util;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.cutebow.crystal_anchor_models.render.ObjRenderer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public final class AssetScanner {
    private static final List<String> OBJ_BASES = new ArrayList<String>();
    private static final Path USER_MODELS_DIR = FabricLoader.getInstance().getConfigDir().resolve("crystal_models").resolve("models");

    private AssetScanner() {
    }

    public static void init() {
        AssetScanner.ensureUserModelsDir();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"crystal_models", (String)"asset_scanner");
            }

            public void method_14491(class_3300 manager) {
                AssetScanner.rescan(manager);
                ObjRenderer.clearDynamic();
            }
        });
    }

    public static void ensureUserModelsDir() {
        try {
            Files.createDirectories(USER_MODELS_DIR, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void rescan(class_3300 manager) {
        OBJ_BASES.clear();
        if (manager != null) {
            Map found = manager.method_14488("models/custom", id -> id.method_12836().equals("crystal_anchor_models") && id.method_12832().endsWith(".obj"));
            for (class_2960 id2 : found.keySet()) {
                String base;
                String path = id2.method_12832();
                int slash = path.lastIndexOf(47);
                int dot = path.lastIndexOf(46);
                if (slash < 0 || dot <= slash || OBJ_BASES.contains(base = path.substring(slash + 1, dot))) continue;
                OBJ_BASES.add(base);
            }
        }
        try (Stream<Path> s = Files.exists(USER_MODELS_DIR, new LinkOption[0]) ? Files.walk(USER_MODELS_DIR, new FileVisitOption[0]) : Stream.empty();){
            s.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().toLowerCase().endsWith(".obj")).forEach(p -> {
                String fn = p.getFileName().toString();
                String base = fn.substring(0, fn.length() - 4);
                if (!OBJ_BASES.contains(base)) {
                    OBJ_BASES.add(base);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(OBJ_BASES);
    }

    public static List<String> getCrystalModels() {
        return OBJ_BASES;
    }

    public static Path getUserModelsDir() {
        return USER_MODELS_DIR;
    }
}

