/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.pluginhelpgui999;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginHelpGUI999
extends JavaPlugin
implements Listener,
CommandExecutor {
    private static final String PERMISSION_USE = "PluginHelpGUI999.use";
    private static final int GUI_SIZE = 54;
    private static final int NAV_PREV_SLOT = 45;
    private static final int NAV_NEXT_SLOT = 53;
    private static final int RELOAD_SLOT = 49;
    private static final String NBT_COMMAND_KEY = "pluginhelpgui999_command";
    private FileConfiguration config;
    private List<String> cachedPluginOrder = new ArrayList<String>();
    private final Map<UUID, Integer> playerMainPage = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> playerPluginPage = new HashMap<UUID, Integer>();
    private final Map<UUID, String> playerViewingPlugin = new HashMap<UUID, String>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("pluginhelp").setExecutor((CommandExecutor)this);
        this.autoFillConfig();
        this.reloadPluginOrderCache();
    }

    public void onDisable() {
    }

    private void reloadPluginOrderCache() {
        ConfigurationSection pluginsSection = this.config.getConfigurationSection("plugins");
        if (pluginsSection == null) {
            this.cachedPluginOrder.clear();
            return;
        }
        this.cachedPluginOrder = new ArrayList<String>(pluginsSection.getKeys(false));
    }

    private void autoFillConfig() {
        Plugin[] plugins;
        boolean changed = false;
        ConfigurationSection pluginsSection = this.config.getConfigurationSection("plugins");
        if (pluginsSection == null) {
            this.config.createSection("plugins");
            pluginsSection = this.config.getConfigurationSection("plugins");
            changed = true;
        }
        for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
            PluginDescriptionFile desc;
            Map commands;
            ConfigurationSection pluginSection;
            String pluginName = plugin.getName();
            if (!pluginsSection.contains(pluginName)) {
                pluginSection = pluginsSection.createSection(pluginName);
                pluginSection.set("description", (Object)"No description set");
                pluginSection.createSection("commands");
                changed = true;
            }
            if ((pluginSection = pluginsSection.getConfigurationSection(pluginName)) == null || (commands = (desc = plugin.getDescription()).getCommands()) == null) continue;
            ConfigurationSection commandsSection = pluginSection.getConfigurationSection("commands");
            if (commandsSection == null) {
                pluginSection.createSection("commands");
                commandsSection = pluginSection.getConfigurationSection("commands");
                changed = true;
            }
            for (String cmdName : commands.keySet()) {
                ConfigurationSection cmdSection = commandsSection.getConfigurationSection(cmdName);
                if (cmdSection == null) {
                    cmdSection = commandsSection.createSection(cmdName);
                    cmdSection.set("description", (Object)"No description set");
                    cmdSection.set("permission", (Object)"none");
                    changed = true;
                    continue;
                }
                if ("No description set".equals(cmdSection.getString("description"))) {
                    cmdSection.set("description", (Object)"No description set");
                    changed = true;
                }
                if (!"none".equals(cmdSection.getString("permission"))) continue;
                cmdSection.set("permission", (Object)"none");
                changed = true;
            }
        }
        if (changed) {
            this.saveConfig();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_USE)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        this.playerMainPage.put(player.getUniqueId(), 0);
        this.openMainPluginGUI(player, 0);
        return true;
    }

    private void openMainPluginGUI(Player player, int page) {
        this.reloadPluginOrderCache();
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Plugin Help Browser"));
        int pluginsPerPage = 45;
        int startIndex = page * pluginsPerPage;
        List<String> plugins = this.cachedPluginOrder;
        if (startIndex >= plugins.size() && page > 0) {
            int lastPage = (plugins.size() - 1) / pluginsPerPage;
            this.openMainPluginGUI(player, lastPage);
            return;
        }
        int slot = 0;
        for (int i = startIndex; i < plugins.size() && slot < pluginsPerPage; ++i, ++slot) {
            String pluginName = plugins.get(i);
            ConfigurationSection pluginSection = this.config.getConfigurationSection("plugins." + pluginName);
            String description = pluginSection != null ? pluginSection.getString("description", "No description set") : "No description set";
            ItemStack pluginHead = this.createPluginHead(pluginName, description);
            inv.setItem(slot, pluginHead);
        }
        if (page > 0) {
            inv.setItem(45, this.createNavArrow(true));
        }
        if ((page + 1) * pluginsPerPage < plugins.size()) {
            inv.setItem(53, this.createNavArrow(false));
        }
        inv.setItem(49, this.createReloadButton());
        player.openInventory(inv);
    }

    private ItemStack createPluginHead(String pluginName, String description) {
        ItemStack head = new ItemStack(Material.ZOMBIE_HEAD);
        ItemMeta meta = head.getItemMeta();
        if (meta == null) {
            return head;
        }
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + pluginName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + description);
        lore.add("");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left or Right click to view commands");
        meta.setLore(lore);
        head.setItemMeta(meta);
        return head;
    }

    private ItemStack createNavArrow(boolean left) {
        ItemStack arrow = new ItemStack(Material.ARROW);
        ItemMeta meta = arrow.getItemMeta();
        if (meta == null) {
            return arrow;
        }
        meta.setDisplayName(left ? String.valueOf(ChatColor.GREEN) + "Previous Page" : String.valueOf(ChatColor.GREEN) + "Next Page");
        arrow.setItemMeta(meta);
        return arrow;
    }

    private ItemStack createReloadButton() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(String.valueOf(ChatColor.RED) + "Reload GUI");
        item.setItemMeta(meta);
        return item;
    }

    private void openPluginHelpGUI(Player player, String pluginName, int page) {
        ConfigurationSection pluginSection = this.config.getConfigurationSection("plugins." + pluginName);
        if (pluginSection == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Plugin data not found in config.");
            return;
        }
        ConfigurationSection commandsSection = pluginSection.getConfigurationSection("commands");
        if (commandsSection == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No commands found for plugin.");
            return;
        }
        ArrayList commands = new ArrayList(commandsSection.getKeys(false));
        commands.sort(String::compareToIgnoreCase);
        int commandsPerPage = 45;
        int startIndex = page * commandsPerPage;
        if (startIndex >= commands.size() && page > 0) {
            int lastPage = (commands.size() - 1) / commandsPerPage;
            this.openPluginHelpGUI(player, pluginName, lastPage);
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_AQUA) + "Commands: " + pluginName));
        int slot = 0;
        for (int i = startIndex; i < commands.size() && slot < commandsPerPage; ++i, ++slot) {
            String cmdName = (String)commands.get(i);
            ConfigurationSection cmdSection = commandsSection.getConfigurationSection(cmdName);
            if (cmdSection == null) continue;
            String description = cmdSection.getString("description", "No description set");
            String permission = cmdSection.getString("permission", "none");
            ItemStack cmdHead = this.createCommandHead(cmdName, description, permission);
            inv.setItem(slot, cmdHead);
        }
        if (page > 0) {
            inv.setItem(45, this.createNavArrow(true));
        }
        if ((page + 1) * commandsPerPage < commands.size()) {
            inv.setItem(53, this.createNavArrow(false));
        }
        inv.setItem(49, this.createReloadButton());
        player.openInventory(inv);
        this.playerViewingPlugin.put(player.getUniqueId(), pluginName);
        this.playerPluginPage.put(player.getUniqueId(), page);
    }

    private ItemStack createCommandHead(String commandName, String description, String permission) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta == null) {
            return head;
        }
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + commandName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + description);
        lore.add("");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Permission: " + String.valueOf(ChatColor.WHITE) + permission);
        lore.add("");
        lore.add(String.valueOf(ChatColor.GREEN) + "Left or Right click to execute");
        lore.add(String.valueOf(ChatColor.GREEN) + "Drag to inventory to keep");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)this, NBT_COMMAND_KEY), PersistentDataType.STRING, (Object)commandName);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity human = event.getWhoClicked();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        if (!player.hasPermission(PERMISSION_USE)) {
            return;
        }
        Inventory inv = event.getInventory();
        if (inv == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (title == null) {
            return;
        }
        if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "Plugin Help Browser")) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot < 0 || slot >= inv.getSize()) {
                return;
            }
            if (slot == 45) {
                int currentPage = this.playerMainPage.getOrDefault(player.getUniqueId(), 0);
                if (currentPage > 0) {
                    this.playerMainPage.put(player.getUniqueId(), currentPage - 1);
                    this.openMainPluginGUI(player, currentPage - 1);
                }
                return;
            }
            if (slot == 53) {
                int currentPage = this.playerMainPage.getOrDefault(player.getUniqueId(), 0);
                this.playerMainPage.put(player.getUniqueId(), currentPage + 1);
                this.openMainPluginGUI(player, currentPage + 1);
                return;
            }
            if (slot == 49) {
                this.reloadConfig();
                this.config = this.getConfig();
                this.autoFillConfig();
                this.reloadPluginOrderCache();
                int currentPage = this.playerMainPage.getOrDefault(player.getUniqueId(), 0);
                this.openMainPluginGUI(player, currentPage);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "PluginHelpGUI999 config reloaded and GUI refreshed.");
                return;
            }
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || clicked.getType() != Material.ZOMBIE_HEAD) {
                return;
            }
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String pluginName = ChatColor.stripColor((String)meta.getDisplayName());
            if (pluginName == null || pluginName.isEmpty()) {
                return;
            }
            this.playerPluginPage.put(player.getUniqueId(), 0);
            this.playerViewingPlugin.put(player.getUniqueId(), pluginName);
            this.openPluginHelpGUI(player, pluginName, 0);
        } else if (title.startsWith(String.valueOf(ChatColor.DARK_AQUA) + "Commands: ")) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot < 0 || slot >= inv.getSize()) {
                return;
            }
            if (slot == 45) {
                String pluginName;
                int currentPage = this.playerPluginPage.getOrDefault(player.getUniqueId(), 0);
                if (currentPage > 0 && (pluginName = this.playerViewingPlugin.get(player.getUniqueId())) != null) {
                    this.playerPluginPage.put(player.getUniqueId(), currentPage - 1);
                    this.openPluginHelpGUI(player, pluginName, currentPage - 1);
                }
                return;
            }
            if (slot == 53) {
                int currentPage = this.playerPluginPage.getOrDefault(player.getUniqueId(), 0);
                String pluginName = this.playerViewingPlugin.get(player.getUniqueId());
                if (pluginName != null) {
                    this.playerPluginPage.put(player.getUniqueId(), currentPage + 1);
                    this.openPluginHelpGUI(player, pluginName, currentPage + 1);
                }
                return;
            }
            if (slot == 49) {
                this.reloadConfig();
                this.config = this.getConfig();
                this.autoFillConfig();
                this.reloadPluginOrderCache();
                String pluginName = this.playerViewingPlugin.get(player.getUniqueId());
                if (pluginName != null) {
                    int currentPage = this.playerPluginPage.getOrDefault(player.getUniqueId(), 0);
                    this.openPluginHelpGUI(player, pluginName, currentPage);
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "PluginHelpGUI999 config reloaded and GUI refreshed.");
                return;
            }
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || clicked.getType() != Material.PLAYER_HEAD) {
                return;
            }
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            String commandName = (String)container.get(new NamespacedKey((Plugin)this, NBT_COMMAND_KEY), PersistentDataType.STRING);
            if (commandName == null) {
                return;
            }
            this.executeCommandForPlayer(player, commandName);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
    }

    @EventHandler
    public void onInventoryClickPlayerInventory(InventoryClickEvent event) {
        HumanEntity human = event.getWhoClicked();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        if (!player.hasPermission(PERMISSION_USE)) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        if (clickedInventory.getType() == InventoryType.PLAYER) {
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || clicked.getType() != Material.PLAYER_HEAD) {
                return;
            }
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            String commandName = (String)container.get(new NamespacedKey((Plugin)this, NBT_COMMAND_KEY), PersistentDataType.STRING);
            if (commandName == null) {
                return;
            }
            if (event.getAction() == InventoryAction.PICKUP_ALL || event.getAction() == InventoryAction.PICKUP_HALF) {
                event.setCancelled(true);
                this.executeCommandForPlayer(player, commandName);
            }
        }
    }

    private void executeCommandForPlayer(Player player, String commandName) {
        if (!player.hasPermission(PERMISSION_USE)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to execute commands via PluginHelpGUI999.");
            return;
        }
        String cmd = commandName.startsWith("/") ? commandName.substring(1) : commandName;
        player.closeInventory();
        player.performCommand(cmd);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Executed command: " + String.valueOf(ChatColor.WHITE) + commandName);
        this.getLogger().info(player.getName() + " executed command via GUI: " + commandName);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(PERMISSION_USE)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String commandName = (String)container.get(new NamespacedKey((Plugin)this, NBT_COMMAND_KEY), PersistentDataType.STRING);
        if (commandName == null) {
            return;
        }
        event.setCancelled(true);
        this.executeCommandForPlayer(player, commandName);
    }
}

