/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn;

import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import xox.labvorty.ssm_reborn.data.SSMRebornConfig;
import xox.labvorty.ssm_reborn.gui.screen.SSMRebornConfigScreen;
import xox.labvorty.ssm_reborn.init.SSMRebornBlockEntities;
import xox.labvorty.ssm_reborn.init.SSMRebornBlocks;
import xox.labvorty.ssm_reborn.init.SSMRebornCreativeTabs;
import xox.labvorty.ssm_reborn.init.SSMRebornEntities;
import xox.labvorty.ssm_reborn.init.SSMRebornItems;
import xox.labvorty.ssm_reborn.init.SSMRebornMenus;
import xox.labvorty.ssm_reborn.init.SSMRebornMobEffects;
import xox.labvorty.ssm_reborn.init.SSMRebornParticleOptions;
import xox.labvorty.ssm_reborn.init.SSMRebornRecipeSerializers;

@Mod(value="ssm_reborn")
public class SSMRebornMod {
    public static final String MOD_ID = "ssm_reborn";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ssm_reborn", "ssm_reborn"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SSMRebornMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        SSMRebornBlocks.BLOCKS.register(modEventBus);
        SSMRebornBlockEntities.BLOCK_ENTITY_TYPE.register(modEventBus);
        SSMRebornItems.ITEMS.register(modEventBus);
        SSMRebornEntities.ENTITY_TYPES.register(modEventBus);
        SSMRebornParticleOptions.PARTICLE_TYPES.register(modEventBus);
        SSMRebornMobEffects.MOB_EFFECTS.register(modEventBus);
        SSMRebornMenus.MENUS.register(modEventBus);
        SSMRebornCreativeTabs.CREATIVE_TABS.register(modEventBus);
        SSMRebornRecipeSerializers.SERIALIZERS.register(modEventBus);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SSMRebornConfig.CLIENT_SPEC);
        modLoadingContext.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, prevScreen) -> new SSMRebornConfigScreen((Screen)prevScreen)));
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

