/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.blocks.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import xox.labvorty.ssm_reborn.blocks.block_entities.PlanetBlockEntity;
import xox.labvorty.ssm_reborn.models.PlanetModel;

public class PlanetBlockEntityRenderer
implements BlockEntityRenderer<PlanetBlockEntity> {
    private final PlanetModel planetModel;
    private static int ticks;
    private static final List<String> ALLOWED_TEXTURES;
    private static final String DEFAULT_TEXTURE = "overworld";

    public PlanetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.planetModel = new PlanetModel(context.m_173582_(PlanetModel.LAYER_LOCATION));
    }

    public void render(PlanetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (blockEntity == null) {
            return;
        }
        ++ticks;
        boolean doubleTexture = blockEntity.doubleTexture;
        String textureOne = blockEntity.textureOne;
        if (textureOne == null) {
            textureOne = DEFAULT_TEXTURE;
        }
        if (!ALLOWED_TEXTURES.contains(textureOne)) {
            textureOne = DEFAULT_TEXTURE;
        }
        ResourceLocation resourceLocationOne = new ResourceLocation("ssm_reborn:textures/block/" + textureOne + ".png");
        float redOne = blockEntity.redOne;
        float greenOne = blockEntity.greenOne;
        float blueOne = blockEntity.blueOne;
        float alphaOne = blockEntity.alphaOne;
        String textureTwo = blockEntity.textureTwo;
        if (textureTwo == null) {
            textureTwo = DEFAULT_TEXTURE;
        }
        if (!ALLOWED_TEXTURES.contains(textureTwo)) {
            textureTwo = DEFAULT_TEXTURE;
        }
        ResourceLocation resourceLocationTwo = new ResourceLocation("ssm_reborn:textures/block/" + textureTwo + ".png");
        float redTwo = blockEntity.redTwo;
        float greenTwo = blockEntity.greenTwo;
        float blueTwo = blockEntity.blueTwo;
        float alphaTwo = blockEntity.alphaTwo;
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)ticks / 4.0f));
        VertexConsumer vertexConsumerOne = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)resourceLocationOne));
        this.planetModel.m_7695_(poseStack, vertexConsumerOne, 0xF000F0, OverlayTexture.f_118083_, redOne, greenOne, blueOne, alphaOne);
        if (doubleTexture) {
            VertexConsumer vertexConsumerTwo = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)resourceLocationTwo));
            this.planetModel.m_7695_(poseStack, vertexConsumerTwo, 0xF000F0, OverlayTexture.f_118083_, redTwo, greenTwo, blueTwo, alphaTwo);
        }
        poseStack.m_85849_();
    }

    static {
        ALLOWED_TEXTURES = List.of("test_texture", "cold", DEFAULT_TEXTURE, "overworld_colorable_one", "overworld_colorable_two", "misr");
    }
}

