/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.data.storages.GlobalWorldData;
import xox.labvorty.ssm_reborn.data.storages.SafetyRegionsData;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;

public class SSMRebornMainServerCommand {
    private static final SuggestionProvider<CommandSourceStack> DIMENSION_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)context.getSource()).m_81377_().m_129784_().stream().map(ResourceKey::m_135782_).map(location -> "\"" + location.toString() + "\""), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ssm_reborn").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"go_to").requires(player -> player.m_6761_(4))).then(Commands.m_82129_((String)"name", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(DIMENSION_SUGGESTIONS).executes(context -> {
            ResourceLocation dimensionLocation = new ResourceLocation(StringArgumentType.getString((CommandContext)context, (String)"dimension"));
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionLocation);
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81377_().m_129880_(dimensionKey);
            if (level != null) {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"name");
                player.m_8999_(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146909_(), player.m_146908_());
            }
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            ResourceLocation dimensionLocation = new ResourceLocation(StringArgumentType.getString((CommandContext)context, (String)"dimension"));
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionLocation);
            Vec3 vec3 = Vec3Argument.m_120844_((CommandContext)context, (String)"location");
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81377_().m_129880_(dimensionKey);
            if (level != null) {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"name");
                player.m_8999_(level, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), player.m_146909_(), player.m_146908_());
            }
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"time_pressure").requires(player -> player.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"active").then(Commands.m_82129_((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean active;
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            GlobalWorldData data = SSMRebornMainServerCommand.getOrCreateWorldData((Level)level);
            data.timePressureActive = active = BoolArgumentType.getBool((CommandContext)context, (String)"active");
            data.m_77762_();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set time pressure active to: " + active)), true);
            return 1;
        })))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int slevel;
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            GlobalWorldData data = SSMRebornMainServerCommand.getOrCreateWorldData((Level)level);
            data.globalTimePressureLevel = slevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            data.m_77762_();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set time pressure level to: " + slevel)), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"active").executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            GlobalWorldData data = SSMRebornMainServerCommand.getOrCreateWorldData((Level)level);
            boolean active = data.timePressureActive;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Time pressure active is set to: " + active)), true);
            return 1;
        }))).then(Commands.m_82127_((String)"level").executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            GlobalWorldData data = SSMRebornMainServerCommand.getOrCreateWorldData((Level)level);
            int slevel = data.globalTimePressureLevel;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Time pressure level is set to: " + slevel)), true);
            return 1;
        }))).then(Commands.m_82127_((String)"safety_regions").executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            SafetyRegionsData data = SSMRebornMainServerCommand.getOrCreateSafetyRegionsData((Level)level);
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            List<String> dimension = data.dimension;
            List<Vector3f> locationOne = data.locationOne;
            List<Vector3f> locationTwo = data.locationTwo;
            for (int i = 0; i < dimension.size(); ++i) {
                String string = dimension.get(i);
                Vector3f locOne = locationOne.get(i);
                Vector3f locTwo = locationTwo.get(i);
                components.add(Component.m_237113_((String)String.format("Index: %s\nDimension: %s\nFrom: [%s, %s, %s]\nTo: [%s, %s, %s]\n", i, string, Float.valueOf(locOne.x()), Float.valueOf(locOne.y()), Float.valueOf(locOne.z()), Float.valueOf(locTwo.x()), Float.valueOf(locTwo.y()), Float.valueOf(locTwo.z()))));
            }
            for (Component component : components) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> component, true);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"safety_regions").then(Commands.m_82129_((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(DIMENSION_SUGGESTIONS).then(Commands.m_82129_((String)"locationOne", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"locationTwo", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            SafetyRegionsData data = SSMRebornMainServerCommand.getOrCreateSafetyRegionsData((Level)level);
            String dimension = StringArgumentType.getString((CommandContext)context, (String)"dimension");
            Vec3 loc1 = Vec3Argument.m_120844_((CommandContext)context, (String)"locationOne");
            Vec3 loc2 = Vec3Argument.m_120844_((CommandContext)context, (String)"locationTwo");
            Vector3f locationOne = loc1.m_252839_();
            Vector3f locationTwo = loc2.m_252839_();
            data.addData(dimension, locationOne, locationTwo);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Added a safety region for dimension \"%s\" at location from: [%s, %s, %s] to: [%s, %s, %s]", dimension, Float.valueOf(locationOne.x()), Float.valueOf(locationOne.y()), Float.valueOf(locationOne.z()), Float.valueOf(locationTwo.x()), Float.valueOf(locationTwo.y()), Float.valueOf(locationTwo.z()))), true);
            return 1;
        }))))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82127_((String)"safety_regions").executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MinecraftServer server = commandSourceStack.m_81377_();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            SafetyRegionsData data = SSMRebornMainServerCommand.getOrCreateSafetyRegionsData((Level)level);
            data.clearData();
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spark").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"display_spark_status").then(Commands.m_82129_((String)"display", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            boolean display = BoolArgumentType.getBool((CommandContext)context, (String)"display");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.display_spark_status = display;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spark_techniques").requires(player -> player.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"logic", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer serverPlayer = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            boolean power = BoolArgumentType.getBool((CommandContext)context, (String)"logic");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_techniques = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            boolean power = BoolArgumentType.getBool((CommandContext)context, (String)"logic");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_techniques = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spark_power").requires(player -> player.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)DoubleArgumentType.doubleArg((double)-0.12)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer serverPlayer = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            double power = DoubleArgumentType.getDouble((CommandContext)context, (String)"power");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_power = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            double power = DoubleArgumentType.getDouble((CommandContext)context, (String)"power");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_power = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"max_spark_power").requires(player -> player.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)DoubleArgumentType.doubleArg((double)-0.12)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer serverPlayer = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            double power = DoubleArgumentType.getDouble((CommandContext)context, (String)"power");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.max_spark_power = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            double power = DoubleArgumentType.getDouble((CommandContext)context, (String)"power");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.max_spark_power = power;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"display_spark_status").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(player -> player.m_6761_(4))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Display Spark Status: " + playerVariables.display_spark_status)), true);
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Display Spark Status: " + playerVariables.display_spark_status)), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spark_techniques").requires(player -> player.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Spark Techniques: " + playerVariables.spark_techniques)), true);
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Spark Techniques: " + playerVariables.spark_techniques)), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spark_power").requires(player -> player.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Spark Power: " + playerVariables.spark_power)), true);
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Spark Techniques: " + playerVariables.spark_power)), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"max_spark_power").requires(player -> player.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Max Spark Power: " + playerVariables.max_spark_power)), true);
            return 1;
        }))).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            commandSourceStack.m_288197_(() -> Component.m_237113_((String)("Max Spark Techniques: " + playerVariables.max_spark_power)), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"magic").requires(player -> player.m_6761_(4))).then(Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mana").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            ServerPlayer serverPlayer = commandSourceStack.m_230896_();
            int mana = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.mana = mana;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer serverPlayer = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            int mana = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.mana = mana;
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"spells").executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            List<String> spell_names = playerVariables.spells;
            ArrayList<MutableComponent> spells = new ArrayList<MutableComponent>();
            for (String string : spell_names) {
                spells.add(Component.m_237115_((String)("ssm_reborn.type." + string)));
            }
            for (Component component : spells) {
                serverPlayer.m_213846_(component);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"mana").executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_230896_();
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            int mana = playerVariables.mana;
            serverPlayer.m_213846_((Component)Component.m_237113_((String)("Player mana is: " + mana)));
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"spells").then(Commands.m_82129_((String)"spell", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_230896_();
            String spell = StringArgumentType.getString((CommandContext)context, (String)"spell");
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spells.add(spell);
                capability.syncData((Entity)serverPlayer);
            });
            return 1;
        }))))));
    }

    public static GlobalWorldData getOrCreateWorldData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (GlobalWorldData)serverLevel.m_8895_().m_164861_(GlobalWorldData::load, GlobalWorldData::new, "ssm_reborn_global_world_data");
    }

    public static SafetyRegionsData getOrCreateSafetyRegionsData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (SafetyRegionsData)serverLevel.m_8895_().m_164861_(SafetyRegionsData::load, SafetyRegionsData::new, "ssm_reborn_safety_regions_data");
    }
}

