/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.data.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import xox.labvorty.ssm_reborn.init.SSMRebornItems;
import xox.labvorty.ssm_reborn.models.PlanetModel;

public class PlanetBlockItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final PlanetModel planetModel;
    private static final List<String> ALLOWED_TEXTURES = List.of("test_texture", "cold", "overworld", "overworld_colorable_one", "overworld_colorable_two", "misr");
    private static final String DEFAULT_TEXTURE = "overworld";

    public PlanetBlockItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
        this.planetModel = new PlanetModel(modelSet.m_171103_(PlanetModel.LAYER_LOCATION));
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        long ticks = 0L;
        if (minecraft.f_91073_ != null) {
            ticks = minecraft.f_91073_.m_46467_();
        }
        float scale = 1.0f;
        double ytranslation = -1.75;
        float additionalXrot = 0.0f;
        float additionalYrot = 0.0f;
        float additionalZrot = 0.0f;
        switch (displayContext) {
            case GUI: {
                scale = 1.0f;
                ytranslation = 0.0;
                additionalYrot = 45.0f;
                additionalXrot = 22.5f;
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                scale = 0.5f;
                ytranslation = -0.3;
                break;
            }
            case FIXED: {
                additionalYrot = 180.0f;
                break;
            }
            case GROUND: {
                scale = 0.75f;
                ytranslation = -0.3;
            }
        }
        LocalPlayer player = minecraft.f_91074_;
        if (itemStack.m_41720_() == SSMRebornItems.PLANET_BLOCK.get()) {
            CompoundTag compoundTag = itemStack.m_41784_().m_6426_();
            boolean doubleTexture = false;
            String textureOne = DEFAULT_TEXTURE;
            ResourceLocation resourceLocationOne = new ResourceLocation("ssm_reborn:textures/block/" + textureOne + ".png");
            float redOne = 1.0f;
            float greenOne = 1.0f;
            float blueOne = 1.0f;
            float alphaOne = 1.0f;
            String textureTwo = DEFAULT_TEXTURE;
            ResourceLocation resourceLocationTwo = new ResourceLocation("ssm_reborn:textures/block/" + textureTwo + ".png");
            float redTwo = 1.0f;
            float greenTwo = 1.0f;
            float blueTwo = 1.0f;
            float alphaTwo = 1.0f;
            if (compoundTag.m_128441_("BlockEntityTag")) {
                CompoundTag blockEntityTag = compoundTag.m_128469_("BlockEntityTag");
                if (blockEntityTag.m_128441_("doubleTexture")) {
                    doubleTexture = blockEntityTag.m_128471_("doubleTexture");
                }
                if (blockEntityTag.m_128441_("textureOne")) {
                    textureOne = blockEntityTag.m_128461_("textureOne");
                    if (textureOne == null) {
                        textureOne = DEFAULT_TEXTURE;
                    }
                    if (!ALLOWED_TEXTURES.contains(textureOne)) {
                        textureOne = DEFAULT_TEXTURE;
                    }
                    resourceLocationOne = new ResourceLocation("ssm_reborn:textures/block/" + textureOne + ".png");
                }
                if (blockEntityTag.m_128441_("textureTwo")) {
                    textureTwo = blockEntityTag.m_128461_("textureTwo");
                    if (textureTwo == null) {
                        textureTwo = DEFAULT_TEXTURE;
                    }
                    if (!ALLOWED_TEXTURES.contains(textureTwo)) {
                        textureTwo = DEFAULT_TEXTURE;
                    }
                    resourceLocationTwo = new ResourceLocation("ssm_reborn:textures/block/" + textureTwo + ".png");
                }
                if (blockEntityTag.m_128441_("redOne")) {
                    redOne = blockEntityTag.m_128457_("redOne");
                }
                if (blockEntityTag.m_128441_("greenOne")) {
                    greenOne = blockEntityTag.m_128457_("greenOne");
                }
                if (blockEntityTag.m_128441_("blueOne")) {
                    blueOne = blockEntityTag.m_128457_("blueOne");
                }
                if (blockEntityTag.m_128441_("alphaOne")) {
                    alphaOne = blockEntityTag.m_128457_("alphaOne");
                }
                if (blockEntityTag.m_128441_("redTwo")) {
                    redTwo = blockEntityTag.m_128457_("redTwo");
                }
                if (blockEntityTag.m_128441_("greenTwo")) {
                    greenTwo = blockEntityTag.m_128457_("greenTwo");
                }
                if (blockEntityTag.m_128441_("blueTwo")) {
                    blueTwo = blockEntityTag.m_128457_("blueTwo");
                }
                if (blockEntityTag.m_128441_("alphaTwo")) {
                    alphaTwo = blockEntityTag.m_128457_("alphaTwo");
                }
            }
            poseStack.m_85836_();
            poseStack.m_85841_(scale, -scale, scale);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5 / (double)scale, ytranslation / (double)scale, -0.5 / (double)scale);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(additionalXrot));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(additionalYrot + (float)ticks / 4.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(additionalZrot));
            VertexConsumer vertexConsumerOne = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)resourceLocationOne));
            this.planetModel.m_7695_(poseStack, vertexConsumerOne, 0xF000F0, OverlayTexture.f_118083_, redOne, greenOne, blueOne, alphaOne);
            if (doubleTexture) {
                VertexConsumer vertexConsumerTwo = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)resourceLocationTwo));
                this.planetModel.m_7695_(poseStack, vertexConsumerTwo, 0xF000F0, OverlayTexture.f_118083_, redTwo, greenTwo, blueTwo, alphaTwo);
            }
            poseStack.m_85849_();
        }
    }
}

