/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.data.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import xox.labvorty.ssm_reborn.SSMRebornMod;

@Mod.EventBusSubscriber(modid="ssm_reborn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SSMRebornPlayerVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void initMessages(FMLCommonSetupEvent event) {
        SSMRebornMod.addNetworkMessage(PlayerVariablesMessage.class, PlayerVariablesMessage::buffer, PlayerVariablesMessage::new, PlayerVariablesMessage::handler);
    }

    @SubscribeEvent
    public static void initCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesMessage {
        private final PlayerVariables data;

        public PlayerVariablesMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readData((Tag)buffer.m_130260_());
        }

        public PlayerVariablesMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeData());
        }

        public static void handler(PlayerVariablesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.dimension_origin = message.data.dimension_origin;
                    variables.x_origin = message.data.x_origin;
                    variables.y_origin = message.data.y_origin;
                    variables.z_origin = message.data.z_origin;
                    variables.time_pressure = message.data.time_pressure;
                    variables.display_spark_status = message.data.display_spark_status;
                    variables.spark_techniques = message.data.spark_techniques;
                    variables.spark_charging = message.data.spark_charging;
                    variables.spark_charge = message.data.spark_charge;
                    variables.spark_power = message.data.spark_power;
                    variables.max_spark_power = message.data.max_spark_power;
                    variables.mana = message.data.mana;
                    variables.spells = message.data.spells;
                    variables.spell_slot_main = message.data.spell_slot_main;
                    variables.spell_slot_one = message.data.spell_slot_one;
                    variables.spell_slot_two = message.data.spell_slot_two;
                    variables.spell_slot_three = message.data.spell_slot_three;
                    variables.time_unlinked = message.data.time_unlinked;
                    variables.time_unlinked_period = message.data.time_unlinked_period;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String dimension_origin = "";
        public double x_origin = 0.0;
        public double y_origin = 0.0;
        public double z_origin = 0.0;
        public int time_pressure = 0;
        public boolean display_spark_status = true;
        public boolean spark_techniques = false;
        public boolean spark_charging = false;
        public int spark_charge = 0;
        public double spark_power = 1.0;
        public double max_spark_power = 1.0;
        public int mana = 8;
        public List<String> spells = new ArrayList<String>();
        public String spell_slot_main = "";
        public String spell_slot_one = "";
        public String spell_slot_two = "";
        public String spell_slot_three = "";
        public boolean time_unlinked = false;
        public int time_unlinked_period = 0;

        public Tag writeData() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("dimension_origin", this.dimension_origin);
            compoundTag.m_128347_("x_origin", this.x_origin);
            compoundTag.m_128347_("y_origin", this.y_origin);
            compoundTag.m_128347_("z_origin", this.z_origin);
            compoundTag.m_128405_("time_pressure", this.time_pressure);
            compoundTag.m_128379_("display_spark_status", this.display_spark_status);
            compoundTag.m_128379_("spark_techniques", this.spark_techniques);
            compoundTag.m_128379_("spark_charging", this.spark_charging);
            compoundTag.m_128405_("sparkCharge", this.spark_charge);
            compoundTag.m_128347_("spark_power", this.spark_power);
            compoundTag.m_128347_("max_spark_power", this.max_spark_power);
            compoundTag.m_128405_("mana", this.mana);
            ListTag spellsTag = new ListTag();
            for (String spell : this.spells) {
                spellsTag.add((Object)StringTag.m_129297_((String)spell));
            }
            compoundTag.m_128365_("spellsTag", (Tag)spellsTag);
            compoundTag.m_128359_("spell_slot_main", this.spell_slot_main);
            compoundTag.m_128359_("spell_slot_one", this.spell_slot_one);
            compoundTag.m_128359_("spell_slot_two", this.spell_slot_two);
            compoundTag.m_128359_("spell_slot_three", this.spell_slot_three);
            compoundTag.m_128379_("time_unlinked", this.time_unlinked);
            compoundTag.m_128405_("time_unlinked_period", this.time_unlinked_period);
            return compoundTag;
        }

        public void readData(Tag tag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.dimension_origin = compoundTag.m_128461_("dimension_origin");
            this.x_origin = compoundTag.m_128459_("x_origin");
            this.y_origin = compoundTag.m_128459_("y_origin");
            this.z_origin = compoundTag.m_128459_("z_origin");
            this.time_pressure = compoundTag.m_128451_("time_pressure");
            this.display_spark_status = compoundTag.m_128471_("display_spark_status");
            this.spark_techniques = compoundTag.m_128471_("spark_techniques");
            this.spark_charging = compoundTag.m_128471_("spark_charging");
            this.spark_charge = compoundTag.m_128451_("spark_charge");
            this.spark_power = compoundTag.m_128459_("spark_power");
            this.max_spark_power = compoundTag.m_128459_("max_spark_power");
            this.mana = compoundTag.m_128451_("mana");
            ArrayList<String> spells_i = new ArrayList<String>();
            ListTag spellsTag = compoundTag.m_128437_("spellsTag", 8);
            for (int i = 0; i < spellsTag.size(); ++i) {
                spells_i.add(spellsTag.m_128778_(i));
            }
            this.spells = spells_i;
            this.spell_slot_main = compoundTag.m_128461_("spell_slot_main");
            this.spell_slot_one = compoundTag.m_128461_("spell_slot_one");
            this.spell_slot_two = compoundTag.m_128461_("spell_slot_two");
            this.spell_slot_three = compoundTag.m_128461_("spell_slot_three");
            this.time_unlinked = compoundTag.m_128471_("time_unlinked");
            this.time_unlinked_period = compoundTag.m_128451_("time_unlinked_period");
        }

        public void syncData(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SSMRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesMessage(this));
            }
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ssm_reborn", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeData();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readData(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class VariableHandlers {
        @SubscribeEvent
        public static void playerLoginSync(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void playerRespawnSync(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void playerChangedDimensionSync(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.display_spark_status = original.display_spark_status;
            clone.spark_techniques = original.spark_techniques;
            clone.max_spark_power = original.max_spark_power;
            clone.spells = original.spells;
            clone.spell_slot_main = original.spell_slot_main;
            clone.spell_slot_one = original.spell_slot_one;
            clone.spell_slot_two = original.spell_slot_two;
            clone.spell_slot_three = original.spell_slot_three;
            clone.time_unlinked = original.time_unlinked;
            clone.time_unlinked_period = original.time_unlinked_period;
            if (!event.isWasDeath()) {
                clone.dimension_origin = original.dimension_origin;
                clone.x_origin = original.x_origin;
                clone.y_origin = original.y_origin;
                clone.z_origin = original.z_origin;
                clone.time_pressure = original.time_pressure;
                clone.spark_charging = original.spark_charging;
                clone.spark_charge = original.spark_charge;
                clone.spark_power = original.spark_power;
                clone.mana = original.mana;
            }
        }
    }
}

