/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.dimension;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm_reborn.dimension.special_effects.InterworldDimensionSpecialEffects;

@Mod.EventBusSubscriber
public class InterworldDimension {

    @Mod.EventBusSubscriber
    public static class TickEvents {
        @SubscribeEvent
        public static void playerTick(TickEvent.PlayerTickEvent event) {
            if (event == null || event.player == null) {
                return;
            }
            ResourceKey dimension = event.player.m_9236_().m_46472_();
            if (dimension != ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:interworld"))) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                event.player.m_150110_().f_35935_ = true;
                event.player.m_6885_();
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class InterworldFog {
        public static ViewportEvent.ComputeFogColor provider = null;

        public static void setColor(int color) {
            provider.setRed((float)(color >> 16 & 0xFF) / 255.0f);
            provider.setGreen((float)(color >> 8 & 0xFF) / 255.0f);
            provider.setBlue((float)(color & 0xFF) / 255.0f);
        }

        @SubscribeEvent
        public static void computeFogColor(ViewportEvent.ComputeFogColor event) {
            provider = event;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            if (level != null && entity != null) {
                Vec3 entPos = entity.m_20318_((float)provider.getPartialTick());
                if (entity.m_9236_().m_46472_() == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:interworld"))) {
                    InterworldFog.setColor(-16777216);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class DimensionSpecialEffectsHandler {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
            InterworldDimensionSpecialEffects dimensionSpecialEffects = new InterworldDimensionSpecialEffects();
            event.register(new ResourceLocation("ssm_reborn:interworld"), (DimensionSpecialEffects)dimensionSpecialEffects);
        }
    }
}

