/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.dimension.special_effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class InterworldDimensionSpecialEffects
extends DimensionSpecialEffects {
    private VertexBuffer starBuffer;
    private VertexBuffer darkBuffer;

    public InterworldDimensionSpecialEffects() {
        super(2.1474836E9f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.createStars();
        this.createDarkSky();
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogType;
        setupFog.run();
        if (!isFoggy && (fogType = camera.m_167685_()) != FogType.POWDER_SNOW && fogType != FogType.LAVA && !this.doesMobEffectBlockSky(camera)) {
            Vec3 skyColor = CubicSampler.m_130038_((Vec3)camera.m_90583_().m_82520_(2.0, 2.0, 2.0).m_82490_(0.25), (x, y, z) -> Vec3.m_82501_((int)((Biome)level.m_204166_(new BlockPos(x, y, z)).m_203334_()).m_47463_()));
            float time = level.m_46942_(partialTick);
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            FogRenderer.m_109017_();
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            ShaderInstance shader = RenderSystem.getShader();
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shader);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderAurora(level, partialTick, poseStack, projectionMatrix, buffer);
            float celestialPose = 0.0f;
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(celestialPose));
            RenderSystem.setShader(GameRenderer::m_172820_);
            float topY = 61.0f;
            float bottomY = 48.0f;
            double playerY = mc.f_91074_.m_146892_().f_82480_;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            if (playerY > (double)bottomY) {
                float alpha = (float)Mth.m_14008_((double)((playerY - (double)bottomY) / (double)(topY - bottomY)), (double)0.0, (double)1.0);
                float size = 40.0f;
                float starBrightness = 0.7f;
                if (alpha > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)alpha);
                    FogRenderer.m_109017_();
                    this.starBuffer.m_85921_();
                    this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    setupFog.run();
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public Vec3 m_5927_(Vec3 color, float sunHeight) {
        return color;
    }

    public boolean m_5781_(int x, int y) {
        return false;
    }

    private boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21023_(MobEffects.f_19610_) || livingEntity.m_21023_(MobEffects.f_216964_);
        }
        return false;
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawColoredStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawColoredStars(BufferBuilder builder) {
        RandomSource random = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float[][] starColors = new float[][]{{1.0f, 1.0f, 1.0f}, {0.4f, 0.8f, 0.9f}, {0.3f, 0.5f, 1.0f}, {0.9f, 0.2f, 0.1f}, {0.9f, 0.5f, 0.1f}, {0.9f, 0.9f, 0.3f}};
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.m_188501_() * 2.0f - 1.0f;
            double d1 = random.m_188501_() * 2.0f - 1.0f;
            double d2 = random.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + random.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            d0 *= d4;
            d1 *= d4;
            d2 *= d4;
            float[] color = starColors[random.m_188503_(starColors.length)];
            float brightness = 0.7f + random.m_188501_() * 0.3f;
            float r = color[0] * brightness;
            float g = color[1] * brightness;
            float b = color[2] * brightness;
            double d5 = d0 * 100.0;
            double d6 = d1 * 100.0;
            double d7 = d2 * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_85950_(r, g, b, 1.0f).m_5752_();
            }
        }
        return builder.m_231175_();
    }

    private void renderAurora(ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, BufferBuilder buffer) {
        Minecraft mc = Minecraft.m_91087_();
        float time = (float)level.m_46468_() / 4.0f;
        float maxAlpha = 0.5f + 0.2f * Mth.m_14031_((float)(time * (float)Math.PI * 0.05f));
        float auroraHeight = 5.0f;
        float auroraThickness = 48.0f;
        float stripThickness = auroraThickness / 2.0f;
        int auroraSegments = 48;
        float auroraRadius = 100.0f;
        int layers = 2;
        float[][] colors = new float[][]{{0.0f, 0.5f, 0.9f}, {0.0f, 0.2f, 0.8f}, {0.1f, 0.2f, 0.9f}, {0.0f, 0.5f, 0.9f}};
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -auroraHeight, 0.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (int layer = 0; layer < layers; ++layer) {
            float b;
            float g;
            float r;
            float lerp;
            int colorIndex2;
            int colorIndex1;
            float colorPos;
            float yBottom;
            float yTop;
            float z;
            float x;
            float waveOffset;
            float angle;
            int i;
            float layerOffset = (float)layer * 0.5f;
            float layerAlpha = maxAlpha * (1.0f - (float)layer * 0.3f);
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (i = 0; i <= auroraSegments; ++i) {
                angle = (float)i / (float)auroraSegments * (float)Math.PI * 2.0f;
                waveOffset = Mth.m_14031_((float)(angle * 5.0f + time * 0.1f)) * 2.0f;
                x = Mth.m_14089_((float)angle) * auroraRadius;
                z = Mth.m_14031_((float)angle) * auroraRadius + layerOffset;
                yTop = waveOffset;
                yBottom = waveOffset - stripThickness;
                colorPos = (float)i / (float)auroraSegments;
                colorIndex1 = (int)(colorPos * (float)colors.length) % colors.length;
                colorIndex2 = (colorIndex1 + 1) % colors.length;
                lerp = colorPos * (float)colors.length - (float)((int)(colorPos * (float)colors.length));
                r = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][0], (float)colors[colorIndex2][0]);
                g = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][1], (float)colors[colorIndex2][1]);
                b = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][2], (float)colors[colorIndex2][2]);
                buffer.m_252986_(matrix, x, yTop, z).m_85950_(r, g, b, 0.0f).m_5752_();
                buffer.m_252986_(matrix, x, yBottom, z).m_85950_(r, g, b, layerAlpha).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (i = 0; i <= auroraSegments; ++i) {
                angle = (float)i / (float)auroraSegments * (float)Math.PI * 2.0f;
                waveOffset = Mth.m_14031_((float)(angle * 5.0f + time * 0.1f)) * 2.0f;
                x = Mth.m_14089_((float)angle) * auroraRadius;
                z = Mth.m_14031_((float)angle) * auroraRadius + layerOffset;
                yTop = waveOffset - stripThickness;
                yBottom = waveOffset - auroraThickness;
                colorPos = (float)i / (float)auroraSegments;
                colorIndex1 = (int)(colorPos * (float)colors.length) % colors.length;
                colorIndex2 = (colorIndex1 + 1) % colors.length;
                lerp = colorPos * (float)colors.length - (float)((int)(colorPos * (float)colors.length));
                r = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][0], (float)colors[colorIndex2][0]);
                g = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][1], (float)colors[colorIndex2][1]);
                b = Mth.m_14179_((float)lerp, (float)colors[colorIndex1][2], (float)colors[colorIndex2][2]);
                buffer.m_252986_(matrix, x, yTop, z).m_85950_(r, g, b, layerAlpha).m_5752_();
                buffer.m_252986_(matrix, x, yBottom, z).m_85950_(r, g, b, 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        }
        poseStack.m_85849_();
    }

    private void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = InterworldDimensionSpecialEffects.buildSkyDisc(bufferbuilder, 16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float y) {
        return LevelRenderer.m_234267_((BufferBuilder)builder, (float)y);
    }
}

