/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.entities.projectiles;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.init.SSMRebornEntities;
import xox.labvorty.ssm_reborn.particles.options.ColorableParticleOptions;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MoonBowProjectile
extends AbstractHurtingProjectile
implements ItemSupplier {
    private boolean inGround;
    private static final double TURN_RATE = 0.2;
    private static final double MAX_SPEED = 1.5;
    private static final double MIN_SPEED = 1.0;
    private static final double TARGET_RADIUS = 30.0;

    public MoonBowProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)SSMRebornEntities.MOON_BOW_PROJECTILE.get(), world);
    }

    public MoonBowProjectile(EntityType<? extends MoonBowProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MoonBowProjectile(EntityType<? extends MoonBowProjectile> entityType, double x, double y, double z, Level level) {
        super(entityType, level);
        this.m_6034_(x, y, z);
    }

    public MoonBowProjectile(EntityType<? extends MoonBowProjectile> type, LivingEntity livingEntity, Level level) {
        super(type, level);
        this.m_5602_((Entity)livingEntity);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return new ColorableParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f));
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        boolean flag = false;
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        this.m_20242_(true);
        LivingEntity livingEntity = MoonBowProjectile.findNearestTarget((LevelAccessor)this.m_9236_(), (Entity)this, this.m_19749_());
        if (livingEntity != null) {
            Vec3 targetPos = livingEntity.m_20182_();
            Vec3 arrowPos = this.m_20182_();
            Vec3 desiredDirection = targetPos.m_82546_(arrowPos).m_82541_();
            Vec3 currentMovement = this.m_20184_();
            if (currentMovement.m_82553_() > 0.0) {
                Vec3 newDirection = currentMovement.m_82541_().m_82490_(0.8).m_82549_(desiredDirection.m_82490_(0.2)).m_82541_();
                double speed = Mth.m_14008_((double)currentMovement.m_82553_(), (double)1.0, (double)1.5);
                this.m_20256_(newDirection.m_82490_(speed));
            }
        }
        if (this.getPersistentData().m_128459_("despawn") < 6000.0) {
            this.getPersistentData().m_128347_("despawn", 1.0 + this.getPersistentData().m_128459_("despawn"));
        } else if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        if (this.inGround) {
            this.m_146870_();
        }
    }

    private static LivingEntity findNearestTarget(LevelAccessor world, Entity projectile, Entity shooter) {
        Vec3 center = projectile.m_20182_();
        AABB searchArea = AABB.m_165882_((Vec3)center, (double)60.0, (double)60.0, (double)60.0);
        return world.m_6443_(LivingEntity.class, searchArea, e -> e != shooter && e != projectile && e.m_6084_()).stream().min(Comparator.comparingDouble(e -> e.m_20238_(center))).orElse(null);
    }

    public static MoonBowProjectile shoot(Level world, LivingEntity entity, RandomSource source) {
        return MoonBowProjectile.shoot(world, entity, source, 1.0f, 0.0, 0);
    }

    public static MoonBowProjectile shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return MoonBowProjectile.shoot(world, entity, source, pullingPower * 1.0f, 0.0, 0);
    }

    public static MoonBowProjectile shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MoonBowProjectile entityarrow = new MoonBowProjectile((EntityType<? extends MoonBowProjectile>)((EntityType)SSMRebornEntities.MOON_BOW_PROJECTILE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static MoonBowProjectile shoot(LivingEntity entity, LivingEntity target) {
        MoonBowProjectile entityarrow = new MoonBowProjectile((EntityType<? extends MoonBowProjectile>)((EntityType)SSMRebornEntities.MOON_BOW_PROJECTILE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

