/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm_reborn.data.storages.GlobalWorldData;
import xox.labvorty.ssm_reborn.utilities.DimensionDataCopyAssist;

@Mod.EventBusSubscriber
public class DimensionSyncEvent {
    @SubscribeEvent
    public static void serverStarting(PlayerEvent.PlayerLoggedInEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        MinecraftServer server = event.getEntity().m_20194_();
        ServerLevel dataLevel = server.m_129880_(Level.f_46428_);
        GlobalWorldData data = DimensionSyncEvent.getOrCreateWorldData((Level)dataLevel);
        if (!data.prunusSetup) {
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "prunus", "r.0.0.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "prunus", "r.-1.0.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "prunus", "r.0.-1.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "prunus", "r.-1.-1.mca");
            data.prunusSetup = true;
            data.m_77762_();
        }
        if (!data.interworldSetup) {
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "interworld", "r.0.0.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "interworld", "r.-1.0.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "interworld", "r.0.-1.mca");
            DimensionDataCopyAssist.preloadDimensionData(dataLevel, "interworld", "r.-1.-1.mca");
            data.interworldSetup = true;
            data.m_77762_();
        }
    }

    public static GlobalWorldData getOrCreateWorldData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (GlobalWorldData)serverLevel.m_8895_().m_164861_(GlobalWorldData::load, GlobalWorldData::new, "ssm_reborn_global_world_data");
    }
}

