/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.SSMRebornMod;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;
import xox.labvorty.ssm_reborn.init.SSMRebornMobEffects;
import xox.labvorty.ssm_reborn.particles.options.ColorableParticleOptions;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final List<ResourceKey<Level>> RESTRICTED_ENTRY_DIMENSIONS = List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:prunus")));
    private static final ResourceKey<Level> prunus = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:prunus"));

    @SubscribeEvent
    public static void playerChatPrunus(ServerChatEvent event) {
        if (event == null || event.getPlayer() == null || event.getMessage() == null) {
            return;
        }
        ServerPlayer serverPlayer = event.getPlayer();
        Level serverPlayerLevel = serverPlayer.m_9236_();
        ResourceKey dimension = serverPlayer.m_9236_().m_46472_();
        String text = event.getRawText();
        if (RESTRICTED_ENTRY_DIMENSIONS.contains(dimension) || serverPlayer.m_21023_((MobEffect)SSMRebornMobEffects.SPARK_ANOMALY.get()) || serverPlayer.m_9236_().f_46443_) {
            return;
        }
        if (text.toLowerCase().contains("prunus")) {
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.dimension_origin = serverPlayer.m_9236_().m_46472_().m_135782_().m_135827_() + ":" + serverPlayer.m_9236_().m_46472_().m_135782_().m_135815_();
                capability.x_origin = serverPlayer.m_20185_();
                capability.y_origin = serverPlayer.m_20186_();
                capability.z_origin = serverPlayer.m_20189_();
                capability.syncData((Entity)serverPlayer);
            });
            SSMRebornMod.LOGGER.info("Player travelling from: " + serverPlayer.m_9236_().m_46472_().m_135782_().m_135827_() + ":" + serverPlayer.m_9236_().m_46472_().m_135782_().m_135815_() + " With location: " + serverPlayer.m_20185_() + " " + serverPlayer.m_20186_() + " " + serverPlayer.m_20189_());
            ServerLevel prunusLevel = serverPlayer.f_8924_.m_129880_(prunus);
            if (prunusLevel != null) {
                if (serverPlayerLevel instanceof ServerLevel) {
                    ServerLevel serverPlayerServerLevel = (ServerLevel)serverPlayerLevel;
                    serverPlayerServerLevel.m_8767_((ParticleOptions)new ColorableParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f)), serverPlayer.m_20185_(), serverPlayer.m_20186_() + (double)(serverPlayer.m_20206_() / 2.0f), serverPlayer.m_20189_(), 100, 0.1, 0.1, 0.1, 0.1);
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
                serverPlayer.m_8999_(prunusLevel, 0.0, 67.0, 0.0, 0.0f, 0.0f);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
                for (MobEffectInstance mobEffectInstance : serverPlayer.m_21220_()) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), mobEffectInstance));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
            }
        }
    }

    @SubscribeEvent
    public static void playerChatMalus(ServerChatEvent event) {
        if (event == null || event.getPlayer() == null || event.getMessage() == null) {
            return;
        }
        ServerPlayer serverPlayer = event.getPlayer();
        Level serverPlayerLevel = serverPlayer.m_9236_();
        ResourceKey dimension = serverPlayer.m_9236_().m_46472_();
        String text = event.getRawText();
        if (dimension != prunus) {
            return;
        }
        if (text.toLowerCase().contains("malus")) {
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            String dimension_origin = playerVariables.dimension_origin;
            double x_origin = playerVariables.x_origin;
            double y_origin = playerVariables.y_origin;
            double z_origin = playerVariables.z_origin;
            ResourceKey origin_dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimension_origin));
            ServerLevel serverLevel = serverPlayer.f_8924_.m_129880_(origin_dimension);
            if (serverPlayerLevel instanceof ServerLevel) {
                ServerLevel serverPlayerServerLevel = (ServerLevel)serverPlayerLevel;
                serverPlayerServerLevel.m_8767_((ParticleOptions)new ColorableParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f)), serverPlayer.m_20185_(), serverPlayer.m_20186_() + (double)(serverPlayer.m_20206_() / 2.0f), serverPlayer.m_20189_(), 100, 0.1, 0.1, 0.1, 0.1);
            }
            if (serverLevel != null) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
                serverPlayer.m_8999_(serverLevel, x_origin, y_origin, z_origin, 0.0f, 0.0f);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
                for (MobEffectInstance mobEffectInstance : serverPlayer.m_21220_()) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), mobEffectInstance));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
            } else {
                serverLevel = serverPlayer.f_8924_.m_129880_(Level.f_46428_);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
                serverPlayer.m_8999_(serverLevel, (double)serverPlayer.m_8961_().m_123341_(), (double)serverPlayer.m_8961_().m_123342_(), (double)serverPlayer.m_8961_().m_123343_(), 0.0f, 0.0f);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
                for (MobEffectInstance mobEffectInstance : serverPlayer.m_21220_()) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), mobEffectInstance));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
                SSMRebornMod.LOGGER.warn("Prunus data was incorrect, safely sending player to Overworld!");
            }
            SSMRebornMod.queueServerWork(20, () -> serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.dimension_origin = "";
                capability.x_origin = 0.0;
                capability.y_origin = 0.0;
                capability.z_origin = 0.0;
                capability.syncData((Entity)serverPlayer);
            }));
        }
    }
}

