/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;
import xox.labvorty.ssm_reborn.init.SSMRebornMobEffects;
import xox.labvorty.ssm_reborn.init.SSMRebornParticleOptions;
import xox.labvorty.ssm_reborn.items.fires.InterworlderMaskColorableItem;
import xox.labvorty.ssm_reborn.items.fires.InterworlderMaskItem;

@Mod.EventBusSubscriber
public class PlayerTickEvent {
    private static final ResourceKey<Level> INTERWORLD = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:interworld"));

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event == null || event.player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Level level = player.m_9236_();
            boolean mask = false;
            if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof InterworlderMaskItem || player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof InterworlderMaskColorableItem) {
                mask = true;
            }
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            if (playerVariables.spark_charging) {
                if (mask) {
                    if (playerVariables.spark_charge >= 200) {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SSMRebornParticleOptions.SPARK_PARTICLE.get()), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f * 2.0f), player.m_20189_(), 50, 0.1, 0.1, 0.1, 0.1);
                            MinecraftServer server = serverLevel.m_7654_();
                            ServerLevel interworldLevel = server.m_129880_(INTERWORLD);
                            if (interworldLevel != null && player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.m_8999_(interworldLevel, 0.0, 128.0, 0.0, 0.0f, 0.0f);
                            }
                        }
                        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            capability.spark_charge = 0;
                            capability.spark_charging = false;
                            capability.syncData((Entity)player);
                        });
                    } else {
                        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            ++capability.spark_charge;
                            capability.syncData((Entity)player);
                        });
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SSMRebornParticleOptions.SPARK_PARTICLE.get()), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f * 2.0f), player.m_20189_(), 1, 0.1, 0.1, 0.1, 0.1);
                        }
                    }
                } else if (playerVariables.spark_charge >= 200) {
                    if (playerVariables.spark_power - 0.3 > 0.0 && !player.m_21023_((MobEffect)SSMRebornMobEffects.FADING_SPARK.get()) && !player.m_21023_((MobEffect)SSMRebornMobEffects.SPARK_ANOMALY.get())) {
                        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            capability.spark_charging = false;
                            capability.spark_charge = 0;
                            capability.syncData((Entity)player);
                        });
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SSMRebornParticleOptions.SPARK_PARTICLE.get()), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f * 2.0f), player.m_20189_(), 50, 0.1, 0.1, 0.1, 0.1);
                            MinecraftServer server = serverLevel.m_7654_();
                            ServerLevel interworldLevel = server.m_129880_(INTERWORLD);
                            if (interworldLevel != null && player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.m_8999_(interworldLevel, 0.0, 128.0, 0.0, 0.0f, 0.0f);
                            }
                        }
                    } else {
                        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            capability.spark_charging = false;
                            capability.spark_charge = 0;
                            capability.syncData((Entity)player);
                        });
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SSMRebornParticleOptions.SPARK_FAILED_PARTICLE.get()), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f * 2.0f), player.m_20189_(), 50, 0.1, 0.1, 0.1, 0.1);
                        }
                    }
                } else if (playerVariables.spark_power - 0.001 > 0.0) {
                    player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        ++capability.spark_charge;
                        capability.spark_power -= 0.001;
                        capability.syncData((Entity)player);
                    });
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SSMRebornParticleOptions.SPARK_PARTICLE.get()), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f * 2.0f), player.m_20189_(), 1, 0.1, 0.1, 0.1, 0.1);
                    }
                } else {
                    player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        capability.spark_charging = false;
                        capability.spark_charge = 0;
                        capability.syncData((Entity)player);
                    });
                }
            }
        }
    }
}

