/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm_reborn.data.configs.SparkPowerConfig;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;
import xox.labvorty.ssm_reborn.init.SSMRebornItems;
import xox.labvorty.ssm_reborn.init.SSMRebornMobEffects;
import xox.labvorty.ssm_reborn.items.skintonite.SkintoniteChunkItem;
import xox.labvorty.ssm_reborn.items.skintonite.SkintoniteCrystalItem;
import xox.labvorty.ssm_reborn.items.skintonite.SkintoniteFacetedItem;
import xox.labvorty.ssm_reborn.items.skintonite.SkintoniteFragmentItem;
import xox.labvorty.ssm_reborn.items.skintonite.SkintoniteGrainItem;

@Mod.EventBusSubscriber
public class SparkEvents {
    @SubscribeEvent
    public static void tickSpark(TickEvent.PlayerTickEvent event) {
        if (event == null || event.player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            double chargeIndex = SparkPowerConfig.getSparkPower(player.m_9236_().m_46472_().m_135782_().toString());
            boolean killableSpace = SparkPowerConfig.getDimmableData(player.m_9236_().m_46472_().m_135782_().toString());
            Inventory inventory = player.m_150109_();
            for (ItemStack stack : inventory.f_35974_) {
                if (stack.m_41720_() instanceof SkintoniteGrainItem || stack.m_41720_() == SSMRebornItems.RAW_SKINTONITE_GRAIN.get()) {
                    chargeIndex -= 0.005 * (double)stack.m_41613_();
                    continue;
                }
                if (stack.m_41720_() instanceof SkintoniteFragmentItem || stack.m_41720_() == SSMRebornItems.RAW_SKINTONITE_FRAGMENT.get() || stack.m_41720_() == SSMRebornItems.PROTECTIVE_SUIT_UNARMORED.get()) {
                    chargeIndex -= 0.045 * (double)stack.m_41613_();
                    continue;
                }
                if (stack.m_41720_() instanceof SkintoniteChunkItem || stack.m_41720_() == SSMRebornItems.RAW_SKINTONITE_CHUNK.get()) {
                    chargeIndex -= 0.405 * (double)stack.m_41613_();
                    continue;
                }
                if (stack.m_41720_() instanceof SkintoniteCrystalItem || stack.m_41720_() == SSMRebornItems.RAW_SKINTONITE_CRYSTAL.get()) {
                    chargeIndex -= 3.645 * (double)stack.m_41613_();
                    continue;
                }
                if (!(stack.m_41720_() instanceof SkintoniteFacetedItem)) continue;
                chargeIndex -= 29.16 * (double)stack.m_41613_();
            }
            double sparkPower = 1.0E-4 * chargeIndex;
            if (!playerVariables.spark_charging) {
                if (chargeIndex > 0.0) {
                    if (playerVariables.spark_power < playerVariables.max_spark_power) {
                        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            capability.spark_power = Mth.m_14008_((double)(capability.spark_power + sparkPower), (double)-0.12, (double)capability.max_spark_power);
                            capability.syncData((Entity)player);
                        });
                    }
                } else {
                    player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        capability.spark_power += sparkPower;
                        capability.syncData((Entity)player);
                    });
                }
            }
            playerVariables = (SSMRebornPlayerVariables.PlayerVariables)player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
            if (killableSpace) {
                if (playerVariables.spark_power <= -0.12) {
                    player.m_6469_(new DamageSource((Holder)event.player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("ssm_reborn:spark_damage")))), Float.POSITIVE_INFINITY);
                }
            } else if (playerVariables.spark_power <= 0.0) {
                player.m_7292_(new MobEffectInstance((MobEffect)SSMRebornMobEffects.FADING_SPARK.get(), 12000, 0, false, false));
            }
        }
    }
}

