/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.data.SSMRebornNoise;
import xox.labvorty.ssm_reborn.data.storages.GlobalWorldData;
import xox.labvorty.ssm_reborn.data.storages.SafetyRegionsData;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;

@Mod.EventBusSubscriber
public class TimePressureCalculation {
    private static final List<String> SAFE_DIMENSIONS = List.of("ssm_reborn:synclyte");

    private static boolean isEntitySafe(Entity entity, List<String> dimensions, List<Vector3f> locationOne, List<Vector3f> locationTwo) {
        String dimension = entity.m_9236_().m_46472_().m_135782_().m_135827_() + ":" + entity.m_9236_().m_46472_().m_135782_().m_135815_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        AABB entityAABB = new AABB(new BlockPos((int)x, (int)y, (int)z));
        if (dimensions.contains(dimension)) {
            for (int i = 0; i < dimensions.size(); ++i) {
                float maxZ;
                float maxY;
                float maxX;
                float minZ;
                float minY;
                if (!dimensions.get(i).equals(dimension)) continue;
                Vector3f locOne = locationOne.get(i);
                Vector3f locTwo = locationTwo.get(i);
                float locOneX = locOne.x();
                float locOneY = locOne.y();
                float locOneZ = locOne.z();
                float locTwoX = locTwo.x();
                float locTwoY = locTwo.y();
                float locTwoZ = locTwo.z();
                float minX = Math.min(locOneX, locTwoX);
                AABB aabb = new AABB((double)minX, (double)(minY = Math.min(locOneY, locTwoY)), (double)(minZ = Math.min(locOneZ, locTwoZ)), (double)(maxX = Math.max(locOneX, locTwoX)), (double)(maxY = Math.max(locOneY, locTwoY)), (double)(maxZ = Math.max(locOneZ, locTwoZ)));
                if (!aabb.m_82381_(entityAABB)) continue;
                return true;
            }
        }
        return SAFE_DIMENSIONS.contains(dimension);
    }

    private static boolean isEntityProtected(Entity entity, int dangerLevel) {
        if (entity instanceof ArmorStand) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof ArmorStand) && livingEntity.m_21223_() > 60.0f && livingEntity.getPersistentData().m_128471_("timeUnlinked")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isPlayerProtected(Player player, int dangerLevel) {
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY).ifPresent(capability -> {
            capability.time_pressure = dangerLevel;
            capability.syncData((Entity)player);
        });
        int charge = chestStack.m_41784_().m_128451_("charge");
        if (charge > 0) {
            chestStack.m_41784_().m_128405_("charge", Mth.m_14045_((int)(charge - dangerLevel), (int)0, (int)Integer.MAX_VALUE));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        ServerLevel dataLevel;
        MinecraftServer server;
        Player player;
        Level level;
        if (event == null || event.player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && !(level = (player = event.player).m_9236_()).m_5776_() && (server = level.m_7654_()) != null && (dataLevel = server.m_129880_(Level.f_46428_)) != null) {
            GlobalWorldData data = TimePressureCalculation.getOrCreateWorldData((Level)dataLevel);
            SafetyRegionsData data1 = TimePressureCalculation.getOrCreateSafetyRegionsData((Level)dataLevel);
            int dangerLevel = SSMRebornNoise.getNoiseValue(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()), dataLevel.m_7328_(), data.globalTimePressureLevel);
            if (!TimePressureCalculation.isEntitySafe((Entity)player, data1.dimension, data1.locationOne, data1.locationTwo) && data.timePressureActive) {
                if (!TimePressureCalculation.isPlayerProtected(player, dangerLevel)) {
                    player.m_6469_(new DamageSource((Holder)dataLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_286973_)), 1.0f);
                }
            } else {
                player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    capability.time_pressure = 0;
                    capability.syncData((Entity)player);
                });
            }
        }
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.m_9236_();
        if (!level.m_5776_()) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
            } else if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            } else {
                ServerLevel dataLevel;
                MinecraftServer server = level.m_7654_();
                if (server != null && (dataLevel = server.m_129880_(Level.f_46428_)) != null) {
                    GlobalWorldData data = TimePressureCalculation.getOrCreateWorldData((Level)dataLevel);
                    SafetyRegionsData data1 = TimePressureCalculation.getOrCreateSafetyRegionsData((Level)dataLevel);
                    int dangerLevel = SSMRebornNoise.getNoiseValue(new BlockPos((int)livingEntity.m_20185_(), (int)livingEntity.m_20186_(), (int)livingEntity.m_20189_()), dataLevel.m_7328_(), data.globalTimePressureLevel);
                    if (!TimePressureCalculation.isEntitySafe((Entity)livingEntity, data1.dimension, data1.locationOne, data1.locationTwo) && data.timePressureActive && !TimePressureCalculation.isEntityProtected((Entity)livingEntity, dangerLevel)) {
                        livingEntity.m_146870_();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.01);
                        }
                    }
                }
            }
        }
    }

    public static GlobalWorldData getOrCreateWorldData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (GlobalWorldData)serverLevel.m_8895_().m_164861_(GlobalWorldData::load, GlobalWorldData::new, "ssm_reborn_global_world_data");
    }

    public static SafetyRegionsData getOrCreateSafetyRegionsData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (SafetyRegionsData)serverLevel.m_8895_().m_164861_(SafetyRegionsData::load, SafetyRegionsData::new, "ssm_reborn_safety_regions_data");
    }
}

