/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.data.storages.GlobalWorldData;
import xox.labvorty.ssm_reborn.data.storages.SafetyRegionsData;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimePressureSpawnPrevention {
    private static final List<String> SAFE_DIMENSIONS = List.of("ssm_reborn:synclyte");

    private static boolean isEntitySafe(Entity entity, List<String> dimensions, List<Vector3f> locationOne, List<Vector3f> locationTwo) {
        String dimension = entity.m_9236_().m_46472_().m_135782_().m_135827_() + ":" + entity.m_9236_().m_46472_().m_135782_().m_135815_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        AABB entityAABB = new AABB(new BlockPos((int)x, (int)y, (int)z));
        if (dimensions.contains(dimension)) {
            for (int i = 0; i < dimensions.size(); ++i) {
                float maxZ;
                float maxY;
                float maxX;
                float minZ;
                float minY;
                if (!dimensions.get(i).equals(dimension)) continue;
                Vector3f locOne = locationOne.get(i);
                Vector3f locTwo = locationTwo.get(i);
                float locOneX = locOne.x();
                float locOneY = locOne.y();
                float locOneZ = locOne.z();
                float locTwoX = locTwo.x();
                float locTwoY = locTwo.y();
                float locTwoZ = locTwo.z();
                float minX = Math.min(locOneX, locTwoX);
                AABB aabb = new AABB((double)minX, (double)(minY = Math.min(locOneY, locTwoY)), (double)(minZ = Math.min(locOneZ, locTwoZ)), (double)(maxX = Math.max(locOneX, locTwoX)), (double)(maxY = Math.max(locOneY, locTwoY)), (double)(maxZ = Math.max(locOneZ, locTwoZ)));
                if (!aabb.m_82381_(entityAABB)) continue;
                return true;
            }
        }
        return SAFE_DIMENSIONS.contains(dimension);
    }

    private static boolean isEntityProtected(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof ArmorStand) && livingEntity.m_21223_() > 60.0f && !livingEntity.getPersistentData().m_128471_("timeUnlinked")) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void entitySpawns(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        MobSpawnType spawnType = event.getSpawnType();
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        ServerLevel serverLevel = serverLevelAccessor.m_6018_();
        GlobalWorldData data = TimePressureSpawnPrevention.getOrCreateWorldData((Level)serverLevel);
        SafetyRegionsData data1 = TimePressureSpawnPrevention.getOrCreateSafetyRegionsData((Level)serverLevel);
        if (spawnType == MobSpawnType.MOB_SUMMONED || spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.DISPENSER || spawnType == MobSpawnType.BUCKET) {
            return;
        }
        if (data.timePressureActive && !TimePressureSpawnPrevention.isEntitySafe((Entity)entity, data1.dimension, data1.locationOne, data1.locationTwo) && !TimePressureSpawnPrevention.isEntityProtected((Entity)entity)) {
            event.setCanceled(true);
        }
    }

    public static GlobalWorldData getOrCreateWorldData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (GlobalWorldData)serverLevel.m_8895_().m_164861_(GlobalWorldData::load, GlobalWorldData::new, "ssm_reborn_global_world_data");
    }

    public static SafetyRegionsData getOrCreateSafetyRegionsData(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("This data can only be accessed on server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (SafetyRegionsData)serverLevel.m_8895_().m_164861_(SafetyRegionsData::load, SafetyRegionsData::new, "ssm_reborn_safety_regions_data");
    }
}

