/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm_reborn.utilities.InterworldAnchor;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterworldOverlay {
    private static final float MAX_POINT_DISTANCE = 200.0f;
    private static List<InterworldAnchor> ANCHORS = new ArrayList<InterworldAnchor>(List.of(new InterworldAnchor(100, 128, 0, "ssm_reborn.dimension.ssm_reborn.misr", 1.0f, 0.3f, 0.0f, true), new InterworldAnchor(25, 128, -35, "ssm_reborn.dimension.minecraft.overworld", 0.0f, 0.0f, 1.0f, true)));
    private static List<InterworldAnchor> SPECIAL_ANCHORS = new ArrayList<InterworldAnchor>(List.of(new InterworldAnchor(Integer.MAX_VALUE, 0, 0, "E", 1.0f, 0.0f, 0.0f, false), new InterworldAnchor(Integer.MIN_VALUE, 0, 0, "W", 1.0f, 0.0f, 0.0f, false), new InterworldAnchor(0, 0, Integer.MIN_VALUE, "N", 1.0f, 0.0f, 0.0f, false), new InterworldAnchor(0, 0, Integer.MAX_VALUE, "S", 1.0f, 0.0f, 0.0f, false)));

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderScreen(RenderGuiEvent.Pre event) {
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        Level world = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            world = player.m_9236_();
            x = player.m_20185_();
            y = player.m_20186_();
            z = player.m_20189_();
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        float guiSize = (float)event.getWindow().m_85445_() / 480.0f;
        ResourceKey dimension = player.m_9236_().m_46472_();
        ResourceKey interworld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:interworld"));
        if (dimension == interworld) {
            InterworldOverlay.drawCompass(guiGraphics, width, height, (Player)player, Minecraft.m_91087_());
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawCompass(GuiGraphics guiGraphics, int width, int height, Player player, Minecraft minecraft) {
        double angleDifference;
        double anchorAngle;
        Vec3 toAnchor;
        Vec3 anchorPos;
        PoseStack poseStack = guiGraphics.m_280168_();
        int centerX = width / 2;
        int compassTop = 15;
        int compassBottom = 25;
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screen/compass_main.png"), centerX - 130, compassTop, 0.0f, 0.0f, 258, 17, 258, 17);
        Vec3 playerPosition = player.m_20182_();
        float playerYaw = player.m_146908_();
        ANCHORS.sort(Comparator.comparingDouble(anchor -> {
            Vec3 anchorPos = anchor.position();
            Vec3 toAnchor = new Vec3(anchorPos.f_82479_ - playerPosition.f_82479_, 0.0, anchorPos.f_82481_ - playerPosition.f_82481_);
            double distance = toAnchor.m_82553_();
            float distanceFactor = (float)Mth.m_14008_((double)(1.0 - distance / 200.0), (double)0.1, (double)1.0);
            return distanceFactor;
        }));
        for (InterworldAnchor anchor2 : ANCHORS) {
            anchorPos = anchor2.position();
            toAnchor = new Vec3(anchorPos.f_82479_ - playerPosition.f_82479_, 0.0, anchorPos.f_82481_ - playerPosition.f_82481_);
            anchorAngle = -Math.toDegrees(Math.atan2(toAnchor.f_82479_, toAnchor.f_82481_));
            angleDifference = Mth.m_14175_((double)(anchorAngle - (double)playerYaw));
            double distance = toAnchor.m_82553_();
            if (!(Math.abs(angleDifference) <= 90.0)) continue;
            double fraction = angleDifference / 90.0;
            int xPos = (int)((double)centerX + fraction * 100.0);
            xPos = Mth.m_14045_((int)xPos, (int)(centerX - 100 + 5), (int)(centerX + 100 - 5));
            float distanceFactor = (float)Mth.m_14008_((double)(1.0 - distance / 200.0), (double)0.1, (double)1.0);
            InterworldOverlay.renderScaledPoint(guiGraphics, minecraft, anchor2, xPos, distanceFactor, anchor2.red(), anchor2.green(), anchor2.blue(), true, distanceFactor);
        }
        for (InterworldAnchor specialAnchor : SPECIAL_ANCHORS) {
            anchorPos = specialAnchor.position();
            toAnchor = new Vec3(anchorPos.f_82479_ - playerPosition.f_82479_, 0.0, anchorPos.f_82481_ - playerPosition.f_82481_);
            anchorAngle = -Math.toDegrees(Math.atan2(toAnchor.f_82479_, toAnchor.f_82481_));
            angleDifference = Mth.m_14175_((double)(anchorAngle - (double)playerYaw));
            if (!(Math.abs(angleDifference) <= 90.0)) continue;
            double fraction = angleDifference / 90.0;
            int xPos = (int)((double)centerX + fraction * 100.0);
            xPos = Mth.m_14045_((int)xPos, (int)(centerX - 100 + 5), (int)(centerX + 100 - 5));
            InterworldOverlay.renderScaledPoint(guiGraphics, minecraft, specialAnchor, xPos, 1.0f, specialAnchor.red(), specialAnchor.green(), specialAnchor.blue(), true, 1.1f);
        }
    }

    private static void renderScaledPoint(GuiGraphics guiGraphics, Minecraft minecraft, InterworldAnchor anchor, int xPos, float scale, float red, float green, float blue, boolean showText, float distanceFactor) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int pointHeight = 12;
        int pointWidth = 4;
        int pointCenterY = 20;
        int pointCenterX = xPos;
        int pointTop = pointCenterY - pointHeight / 2;
        guiGraphics.m_280246_(red, green, blue, scale);
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_((float)pointCenterX / scale, (float)pointCenterY / scale, 1.0f);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screen/compass_mark.png"), -(pointWidth / 2), -(pointHeight / 2), 0.0f, 0.0f, 4, 12, 4, 12);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, distanceFactor * 200.0f);
        if (showText) {
            String name = anchor.useTranslation() ? Component.m_237115_((String)anchor.name()).getString() : anchor.name();
            int textWidth = minecraft.f_91062_.m_92895_(name);
            int textX = xPos - textWidth / 2;
            int textY = pointTop - 10;
            guiGraphics.m_280488_(minecraft.f_91062_, name, textX, textY, 0xFFFFFF);
        }
        poseStack.m_85849_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

