/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;
import xox.labvorty.ssm_reborn.items.MagicCatalyst;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MagicOverlay {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void render(RenderGuiEvent.Pre event) {
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        Level level = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            level = player.m_9236_();
            x = player.m_20185_();
            y = player.m_20186_();
            z = player.m_20189_();
        }
        SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack itemStack = player.m_21206_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Item item = itemStack.m_41720_();
        if (item instanceof MagicCatalyst) {
            MagicCatalyst magicCatalyst = (MagicCatalyst)item;
            int mana = playerVariables.mana;
            String spell = playerVariables.spell_slot_main;
            ResourceLocation spellTexture = new ResourceLocation("ssm_reborn:textures/screen/skint/" + spell + ".png");
            Vector3f color = MagicOverlay.getColorOfSpell(spell);
            RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)0.9f);
            guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screen/skint/magic_window_gradient.png"), 0, 0, 0.0f, 0.0f, 125, 125, 125, 125);
            guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screen/skint/magic_window_small.png"), 0, 0, 0.0f, 0.0f, 51, 51, 51, 51);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.getGuiGraphics().m_280163_(new ResourceLocation("ssm_reborn:textures/screen/skint/magic_window_frame.png"), 0, 0, 0.0f, 0.0f, 71, 71, 71, 71);
            if (!spell.isBlank()) {
                guiGraphics.m_280163_(spellTexture, 7, 8, 0.0f, 0.0f, 29, 29, 29, 29);
            }
            List<Integer> positions = List.of(Integer.valueOf(9), Integer.valueOf(21), Integer.valueOf(32), Integer.valueOf(42), Integer.valueOf(50), Integer.valueOf(57), Integer.valueOf(60), Integer.valueOf(61));
            for (int i = 0; i < mana; ++i) {
                int manaX = positions.get(i);
                int manaY = positions.get(positions.size() - 1 - i);
                guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screen/skint/magic_point.png"), manaX, manaY, 0.0f, 0.0f, 10, 10, 10, 10);
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static Vector3f getColorOfSpell(String spell) {
        String type;
        return switch (type = MagicOverlay.getSpellType(spell)) {
            case "void" -> new Vector3f(0.23f, 0.74f, 0.33f);
            case "sanguimancy" -> new Vector3f(0.58f, 0.19f, 0.2f);
            default -> new Vector3f(1.0f, 1.0f, 1.0f);
        };
    }

    private static String getSpellType(String spell) {
        return switch (spell) {
            case "repulsion", "void_dagger", "void_lightning" -> "void";
            case "hemoglobin_boost" -> "sanguimancy";
            default -> "base";
        };
    }
}

