/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.gui.utility;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class StatusEffect {
    private static final ResourceLocation STATUS_BAR = new ResourceLocation("ssm_reborn:textures/screen/statuseffect_bar.png");
    private static final ResourceLocation STATUS_GRADIENTBAR = new ResourceLocation("ssm_reborn:textures/screen/statuseffect_gradientbar.png");
    private static final ResourceLocation STATUS_MAIN = new ResourceLocation("ssm_reborn:textures/screen/statuseffect_main.png");
    private static final ResourceLocation STATUS_CIRCLE = new ResourceLocation("ssm_reborn:textures/screen/statuseffect_circle.png");
    private static final Map<String, ResourceLocation> TYPE_TEXTURE_MAP = new HashMap<String, ResourceLocation>(Map.ofEntries(Map.entry("fading_spark", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_fadespark.png")), Map.entry("burning", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_burning.png")), Map.entry("weakness", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_weakness.png")), Map.entry("poisoned", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_poisoned.png")), Map.entry("corrupted", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_corrupted.png")), Map.entry("freezing", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_freezing.png")), Map.entry("suffocating", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_suffocating.png")), Map.entry("electrified", new ResourceLocation("ssm_reborn:textures/screen/statuseffect_electrified.png"))));
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("ssm_reborn:textures/screen/statuseffect_fadespark.png");
    private float barLength;
    private Vector3f gradientColorOne;
    private Vector3f gradientColorTwo;
    private Vector3f circleColor;
    private String type;

    public StatusEffect(float barLength, Vector3f gradientColorOne, Vector3f gradientColorTwo, Vector3f circleColor, String type) {
        this.barLength = barLength;
        this.gradientColorOne = gradientColorOne;
        this.gradientColorTwo = gradientColorTwo;
        this.circleColor = circleColor;
        this.type = type;
    }

    public void render(GuiGraphics guiGraphics, float guiSize, int width, int height, int order) {
        this.render(guiGraphics, guiGraphics.m_280168_(), guiSize, width, height, order);
    }

    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float guiSize, int width, int height, int order) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.0625f, 0.0625f, 1.0f);
        poseStack.m_85837_(((double)width / 2.0 - 13.5 * (double)guiSize) / 0.0625, (double)((22.0f * guiSize + 30.0f * guiSize * (float)order) / 0.0625f), 1.0);
        float redOne = this.gradientColorOne.x;
        float greenOne = this.gradientColorOne.y;
        float blueOne = this.gradientColorOne.z;
        guiGraphics.m_280246_(redOne, greenOne, blueOne, 1.0f);
        guiGraphics.m_280163_(STATUS_BAR, 0, 0, 0.0f, 0.0f, (int)(432.0f * this.barLength * guiSize), (int)(44.0f * guiSize), (int)(432.0f * this.barLength * guiSize), (int)(44.0f * guiSize));
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        float redTwo = this.gradientColorTwo.x;
        float greenTwo = this.gradientColorTwo.y;
        float blueTwo = this.gradientColorTwo.z;
        guiGraphics.m_280246_(redTwo, greenTwo, blueTwo, 1.0f);
        guiGraphics.m_280163_(STATUS_GRADIENTBAR, 0, 0, 0.0f, 0.0f, (int)(432.0f * this.barLength * guiSize), (int)(44.0f * guiSize), (int)(432.0f * this.barLength * guiSize), (int)(44.0f * guiSize));
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.25f, 0.25f, 1.0f);
        poseStack.m_85837_(((double)width / 2.0 - 22.75 * (double)guiSize) / 0.25, (double)((20.0f * guiSize + 30.0f * guiSize * (float)order) / 0.25f), 1.0);
        guiGraphics.m_280163_(STATUS_MAIN, 0, 0, 0.0f, 0.0f, (int)(148.0f * guiSize), (int)(26.0f * guiSize), (int)(148.0f * guiSize), (int)(26.0f * guiSize));
        guiGraphics.m_280163_(this.obtainResourceLocationByType(this.type), 0, 0, 0.0f, 0.0f, (int)(148.0f * guiSize), (int)(26.0f * guiSize), (int)(148.0f * guiSize), (int)(26.0f * guiSize));
        guiGraphics.m_280246_(redOne, greenOne, blueOne, 1.0f);
        guiGraphics.m_280163_(STATUS_CIRCLE, 0, 0, 0.0f, 0.0f, (int)(26.0f * guiSize), (int)(26.0f * guiSize), (int)(26.0f * guiSize), (int)(26.0f * guiSize));
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private ResourceLocation obtainResourceLocationByType(String type) {
        return TYPE_TEXTURE_MAP.getOrDefault(type, DEFAULT_TEXTURE);
    }
}

