/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.network;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import xox.labvorty.ssm_reborn.SSMRebornMod;
import xox.labvorty.ssm_reborn.gui.menu.GuidingSkintMainMenu;
import xox.labvorty.ssm_reborn.gui.menu.GuidingSkintSpellsMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuidingSkintMainPacket {
    private final double x;
    private final double y;
    private final double z;
    private final int id;

    public GuidingSkintMainPacket(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.id = buffer.readInt();
    }

    public GuidingSkintMainPacket(double x, double y, double z, int id) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
    }

    public static void buffer(GuidingSkintMainPacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.x);
        buffer.writeDouble(packet.y);
        buffer.writeDouble(packet.z);
        buffer.writeInt(packet.id);
    }

    public static void handler(GuidingSkintMainPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            double x = packet.x;
            double y = packet.y;
            double z = packet.z;
            int id = packet.id;
            if (context.getDirection().getReceptionSide().isServer()) {
                GuidingSkintMainPacket.sHandler((Player)player, x, y, z, id);
            }
        });
        context.setPacketHandled(true);
    }

    public static void sHandler(Player player, double x, double y, double z, final int mainid) {
        Level level = player.m_9236_();
        final BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            try {
                NetworkHooks.openScreen((ServerPlayer)sPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Guiding Skint Main");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player plr) {
                        if (mainid == 1) {
                            return new GuidingSkintSpellsMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(pos));
                        }
                        return new GuidingSkintMainMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(pos));
                    }
                }, (BlockPos)pos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SSMRebornMod.addNetworkMessage(GuidingSkintMainPacket.class, GuidingSkintMainPacket::buffer, GuidingSkintMainPacket::new, GuidingSkintMainPacket::handler);
    }
}

