/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm_reborn.SSMRebornMod;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagicCardsSpellPacket {
    private final String spell;

    public MagicCardsSpellPacket(String spell) {
        this.spell = spell;
    }

    public MagicCardsSpellPacket(FriendlyByteBuf friendlyByteBuf) {
        this.spell = friendlyByteBuf.m_130277_();
    }

    public static void buffer(MagicCardsSpellPacket packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130070_(packet.spell);
    }

    public static void handler(MagicCardsSpellPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            String spell = message.spell;
            serverPlayer.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spell_slot_main = spell;
                capability.syncData((Entity)serverPlayer);
            });
        });
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SSMRebornMod.addNetworkMessage(MagicCardsSpellPacket.class, MagicCardsSpellPacket::buffer, MagicCardsSpellPacket::new, MagicCardsSpellPacket::handler);
    }
}

