/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.network.keybinds;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm_reborn.SSMRebornMod;
import xox.labvorty.ssm_reborn.data.variables.SSMRebornPlayerVariables;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SparkKeyPacket {
    int type;
    int pressedMs;
    private static final List<ResourceKey<Level>> RESTRICTED_DIMENSIONS = List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:prunus")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:interworld")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ssm_reborn:")));

    public SparkKeyPacket(int type, int pressedMs) {
        this.type = type;
        this.pressedMs = pressedMs;
    }

    public SparkKeyPacket(FriendlyByteBuf friendlyByteBuf) {
        this.type = friendlyByteBuf.readInt();
        this.pressedMs = friendlyByteBuf.readInt();
    }

    public static void buffer(SparkKeyPacket packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(packet.type);
        friendlyByteBuf.writeInt(packet.pressedMs);
    }

    public static void handler(SparkKeyPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SparkKeyPacket.action((Player)context.getSender(), packet.type, packet.pressedMs));
        context.setPacketHandled(true);
    }

    public static void action(Player player, int type, int pressedMs) {
        Level level = player.m_9236_();
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        SSMRebornPlayerVariables.PlayerVariables playerVariables = (SSMRebornPlayerVariables.PlayerVariables)player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SSMRebornPlayerVariables.PlayerVariables());
        if (type == 0 && playerVariables.spark_techniques && !RESTRICTED_DIMENSIONS.contains(level.m_46472_())) {
            player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_charging = true;
                capability.syncData((Entity)player);
            });
        }
        if (type == 1) {
            player.getCapability(SSMRebornPlayerVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.spark_charging = false;
                capability.spark_charge = 0;
                capability.syncData((Entity)player);
            });
        }
    }

    @SubscribeEvent
    public static void registerPacket(FMLCommonSetupEvent event) {
        SSMRebornMod.addNetworkMessage(SparkKeyPacket.class, SparkKeyPacket::buffer, SparkKeyPacket::new, SparkKeyPacket::handler);
    }
}

