/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm_reborn.particles.options;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import xox.labvorty.ssm_reborn.init.SSMRebornParticleOptions;

public class ColorableParticleOptions
implements ParticleOptions {
    public final Vector3f color;
    public static final Codec<ColorableParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p -> p.color)).apply((Applicative)instance, ColorableParticleOptions::new));
    public static final ParticleOptions.Deserializer<ColorableParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ColorableParticleOptions>(){

        public ColorableParticleOptions fromCommand(ParticleType<ColorableParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            Vector3f vector3f = ColorableParticleOptions.readVector3f(reader);
            return new ColorableParticleOptions(vector3f);
        }

        public ColorableParticleOptions fromNetwork(ParticleType<ColorableParticleOptions> type, FriendlyByteBuf fbb) {
            return new ColorableParticleOptions(ColorableParticleOptions.readVector3f(fbb));
        }
    };

    public ColorableParticleOptions(Vector3f colour) {
        this.color = colour;
    }

    public static Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
        reader.expect(' ');
        float f1 = reader.readFloat();
        reader.expect(' ');
        float f2 = reader.readFloat();
        reader.expect(' ');
        float f3 = reader.readFloat();
        return new Vector3f(f1, f2, f3);
    }

    public static Vector3f readVector3f(FriendlyByteBuf fbb) {
        return new Vector3f(fbb.readFloat(), fbb.readFloat(), fbb.readFloat());
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)SSMRebornParticleOptions.COLORABLE_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf fbb) {
        fbb.writeFloat(this.color.x());
        fbb.writeFloat(this.color.y());
        fbb.writeFloat(this.color.z());
    }

    public Vector3f getColor() {
        return this.color;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()));
    }
}

