/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import xox.labvorty.ssm.network.SsmRebornModVariables;

public class ArheiDimensionSpecialEffects
extends DimensionSpecialEffects {
    private ResourceLocation MOON_LOCATION = new ResourceLocation("ssm_reborn:textures/arhei_moon.png");
    private VertexBuffer starBuffer;
    private VertexBuffer darkBuffer;

    public ArheiDimensionSpecialEffects() {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.createStars();
        this.createDarkSky();
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogType;
        setupFog.run();
        if (!isFoggy && (fogType = camera.m_167685_()) != FogType.POWDER_SNOW && fogType != FogType.LAVA && !this.doesMobEffectBlockSky(camera)) {
            Vec3 skyColor = CubicSampler.m_130038_((Vec3)camera.m_90583_().m_82520_(2.0, 2.0, 2.0).m_82490_(0.25), (x, y, z) -> Vec3.m_82501_((int)((Biome)level.m_204166_(new BlockPos(x, y, z)).m_203334_()).m_47463_()));
            float time = level.m_46942_(partialTick);
            float r = 0.1f;
            float g = 0.0f;
            float b = 0.1f;
            if (!SsmRebornModVariables.MapVariables.get((LevelAccessor)level).ArheiCovered) {
                r = (float)Mth.m_14139_((double)(1.0 - (double)(Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f + 0.5f)), (double)skyColor.f_82479_, (double)0.1);
                g = (float)Mth.m_14139_((double)(1.0 - (double)(Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f + 0.5f)), (double)skyColor.f_82480_, (double)0.0);
                b = (float)Mth.m_14139_((double)(1.0 - (double)(Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f + 0.5f)), (double)skyColor.f_82481_, (double)0.1);
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            FogRenderer.m_109017_();
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            ShaderInstance shader = RenderSystem.getShader();
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shader);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float celestialPose = 0.0f;
            celestialPose = !SsmRebornModVariables.MapVariables.get((LevelAccessor)level).ArheiCovered ? level.m_46942_(partialTick) * 360.0f : 225.0f;
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(celestialPose));
            RenderSystem.setShader(GameRenderer::m_172820_);
            float topY = 61.0f;
            float bottomY = 48.0f;
            double playerY = mc.f_91074_.m_146892_().f_82480_;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            if (playerY > (double)bottomY) {
                float alpha = (float)Mth.m_14008_((double)((playerY - (double)bottomY) / (double)(topY - bottomY)), (double)0.0, (double)1.0);
                float size = 40.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("ssm_reborn:textures/arhei_moon.png"));
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_252986_(matrix4f, -size, -100.0f, size).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                buffer.m_252986_(matrix4f, size, -100.0f, size).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                buffer.m_252986_(matrix4f, size, -100.0f, -size).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                buffer.m_252986_(matrix4f, -size, -100.0f, -size).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                if (!SsmRebornModVariables.MapVariables.get((LevelAccessor)level).ArheiCovered) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/sun.png"));
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    buffer.m_252986_(matrix4f, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    buffer.m_252986_(matrix4f, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    buffer.m_252986_(matrix4f, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    buffer.m_252986_(matrix4f, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                }
                float starBrightness = 0.7f;
                if (!SsmRebornModVariables.MapVariables.get((LevelAccessor)level).ArheiCovered) {
                    starBrightness = (float)((double)0.7f - (double)(Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f + 0.5f));
                }
                if (alpha > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)alpha);
                    FogRenderer.m_109017_();
                    this.starBuffer.m_85921_();
                    this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    setupFog.run();
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public Vec3 m_5927_(Vec3 color, float sunHeight) {
        return color;
    }

    public boolean m_5781_(int x, int y) {
        return false;
    }

    private boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21023_(MobEffects.f_19610_) || livingEntity.m_21023_(MobEffects.f_216964_);
        }
        return false;
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return builder.m_231175_();
    }

    private void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = ArheiDimensionSpecialEffects.buildSkyDisc(bufferbuilder, 16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float y) {
        return LevelRenderer.m_234267_((BufferBuilder)builder, (float)y);
    }
}

