/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import com.google.common.collect.Lists;
import com.ibm.icu.impl.locale.XCldrStub;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xox.labvorty.ssm.QuietPacketDistributors;
import xox.labvorty.ssm.ReflectionBuddy;
import xox.labvorty.ssm.UnregisterDimensionEvent;
import xox.labvorty.ssm.UpdateDimensionsPacket;

public class DynamicDimensionManager {
    public static final DynamicDimensionManager INSTANCE = new DynamicDimensionManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ResourceKey<Level>> VANILLA_LEVELS = Set.of(Level.f_46428_, Level.f_46429_, Level.f_46430_);
    private Set<ResourceKey<Level>> levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();

    private DynamicDimensionManager() {
    }

    public ServerLevel getOrCreateLevel(MinecraftServer server, ResourceKey<Level> levelKey, Supplier<LevelStem> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(levelKey);
        return existingLevel == null ? DynamicDimensionManager.createAndRegisterLevel(server, map, levelKey, dimensionFactory) : existingLevel;
    }

    public void markDimensionForUnregistration(MinecraftServer server, ResourceKey<Level> levelToRemove) {
        if (!VANILLA_LEVELS.contains(levelToRemove)) {
            this.levelsPendingUnregistration.add(levelToRemove);
        }
    }

    public Set<ResourceKey<Level>> getLevelsPendingUnregistration() {
        return XCldrStub.ImmutableSet.copyOf(this.levelsPendingUnregistration);
    }

    private static ServerLevel createAndRegisterLevel(MinecraftServer server, Map<ResourceKey<Level>, ServerLevel> map, ResourceKey<Level> levelKey, Supplier<LevelStem> dimensionFactory) {
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)levelKey.m_135782_());
        LevelStem dimension = dimensionFactory.get();
        ChunkProgressListener chunkProgressListener = ReflectionBuddy.MinecraftServerAccess.progressListenerFactory.apply(server).m_9620_(11);
        Executor executor = ReflectionBuddy.MinecraftServerAccess.executor.apply(server);
        LevelStorageSource.LevelStorageAccess anvilConverter = ReflectionBuddy.MinecraftServerAccess.storageSource.apply(server);
        WorldData worldData = server.m_129910_();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
        Registry dimensionRegistry = server.m_206579_().m_175515_(Registries.f_256862_);
        if (!(dimensionRegistry instanceof MappedRegistry)) {
            throw new IllegalStateException(String.format("Unable to register dimension %s -- dimension registry not writable", dimensionKey.m_135782_()));
        }
        MappedRegistry writableRegistry = (MappedRegistry)dimensionRegistry;
        writableRegistry.unfreeze();
        writableRegistry.m_255290_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newLevel = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, levelKey, dimension, chunkProgressListener, worldData.m_7513_(), overworld.m_7328_(), List.of(), false, (RandomSequences)null);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newLevel.m_6857_()));
        map.put(levelKey, newLevel);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
        QuietPacketDistributors.sendToAll(NetworkingSSM.CHANNEL, new UpdateDimensionsPacket(Set.of(levelKey), true));
        return newLevel;
    }

    private void unregisterScheduledDimensions(MinecraftServer server) {
        if (this.levelsPendingUnregistration.isEmpty()) {
            return;
        }
        Set<ResourceKey<Level>> keysToRemove = this.levelsPendingUnregistration;
        this.levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();
        Registry oldRegistry = server.m_206579_().m_175515_(Registries.f_256862_);
        if (!(oldRegistry instanceof MappedRegistry)) {
            LOGGER.warn("Cannot unload dimensions: dimension registry not an instance of MappedRegistry. There may be another mod causing incompatibility with Infiniverse, or Infiniverse may need to be updated for your version of forge/minecraft.");
            return;
        }
        MappedRegistry oldMappedRegistry = (MappedRegistry)oldRegistry;
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReflectionBuddy.MinecraftServerAccess.registries.apply(server);
        RegistryAccess.Frozen composite = ReflectionBuddy.LayeredRegistryAccessAccess.composite.apply(layeredRegistryAccess);
        if (!(composite instanceof RegistryAccess.ImmutableRegistryAccess)) {
            LOGGER.warn("Cannot unload dimensions: composite registry not an instance of ImmutableRegistryAccess. There may be another mod causing incompatibility with Infiniverse, or Infiniverse may be updated for your version of forge/minecraft.");
            return;
        }
        RegistryAccess.ImmutableRegistryAccess immutableRegistryAccess = (RegistryAccess.ImmutableRegistryAccess)composite;
        HashSet<ResourceKey<Level>> removedLevelKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        for (ResourceKey<Level> resourceKey : keysToRemove) {
            ServerLevel removedLevel;
            ServerLevel levelToRemove = server.m_129880_(resourceKey);
            if (levelToRemove == null) continue;
            UnregisterDimensionEvent unregisterDimensionEvent = new UnregisterDimensionEvent(levelToRemove);
            MinecraftForge.EVENT_BUS.post((Event)unregisterDimensionEvent);
            if (unregisterDimensionEvent.isCanceled() || (removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(resourceKey)) == null) continue;
            for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.m_6907_())) {
                BlockPos destinationPos;
                ServerLevel destinationLevel;
                ResourceKey respawnKey = player.m_8963_();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = Level.f_46428_;
                    player.m_9158_(respawnKey, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = Level.f_46428_;
                }
                if ((destinationLevel = server.m_129880_(respawnKey)) == null) {
                    destinationLevel = overworld;
                }
                if ((destinationPos = player.m_8961_()) == null) {
                    destinationPos = destinationLevel.m_220360_();
                }
                float respawnAngle = player.m_8962_();
                player.m_8999_(destinationLevel, (double)destinationPos.m_123341_(), (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_(), respawnAngle, 0.0f);
            }
            removedLevel.m_8643_(null, false, removedLevel.m_7441_());
            MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)removedLevel));
            WorldBorder overworldBorder = overworld.m_6857_();
            WorldBorder removedWorldBorder = removedLevel.m_6857_();
            List<BorderChangeListener> listeners = ReflectionBuddy.WorldBorderAccess.listeners.apply(overworldBorder);
            BorderChangeListener targetListener = null;
            for (BorderChangeListener listener : listeners) {
                BorderChangeListener.DelegateBorderChangeListener delegate;
                if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ReflectionBuddy.DelegateBorderChangeListenerAccess.worldBorder.apply(delegate = (BorderChangeListener.DelegateBorderChangeListener)listener)) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.m_156096_(targetListener);
            }
            removedLevelKeys.add(resourceKey);
        }
        if (!removedLevelKeys.isEmpty()) {
            MappedRegistry newRegistry = new MappedRegistry(Registries.f_256862_, oldMappedRegistry.m_203658_());
            for (RegistryLayer[] entry : oldRegistry.m_6579_()) {
                ResourceKey oldKey = (ResourceKey)entry.getKey();
                ResourceKey oldLevelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)oldKey.m_135782_());
                LevelStem dimension = (LevelStem)entry.getValue();
                if (oldKey == null || dimension == null || removedLevelKeys.contains(oldLevelKey)) continue;
                newRegistry.m_255290_(oldKey, (Object)dimension, oldRegistry.m_6228_((Object)dimension));
            }
            ArrayList<RegistryAccess.Frozen> arrayList = new ArrayList<RegistryAccess.Frozen>();
            for (RegistryLayer layer : RegistryLayer.values()) {
                if (layer == RegistryLayer.DIMENSIONS) {
                    arrayList.add(new RegistryAccess.ImmutableRegistryAccess(List.of(newRegistry)).m_203557_());
                    continue;
                }
                arrayList.add(layeredRegistryAccess.m_245283_((Object)layer));
            }
            HashMap<ResourceKey, Registry> newRegistryMap = new HashMap<ResourceKey, Registry>();
            for (RegistryAccess.Frozen registryAccess : arrayList) {
                List registries = registryAccess.m_206193_().toList();
                for (RegistryAccess.RegistryEntry registryEntry : registries) {
                    newRegistryMap.put(registryEntry.f_206233_(), registryEntry.f_206234_());
                }
            }
            ReflectionBuddy.LayeredRegistryAccessAccess.values.set(layeredRegistryAccess, List.copyOf(arrayList));
            ReflectionBuddy.ImmutableRegistryAccessAccess.registries.set(immutableRegistryAccess, newRegistryMap);
            server.markWorldsDirty();
            QuietPacketDistributors.sendToAll(NetworkingSSM.CHANNEL, new UpdateDimensionsPacket(removedLevelKeys, false));
        }
    }

    @Mod.EventBusSubscriber(modid="ssm_reborn")
    public class NetworkingSSM {
        public static final String PROTOCOL_VERSION = "1";
        public static final Predicate<String> NETWORK_TEST = protocol -> PROTOCOL_VERSION.equals(protocol) || NetworkRegistry.ABSENT.equals(protocol) || NetworkRegistry.ACCEPTVANILLA.equals(protocol);
        public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ssm_reborn", "main"), () -> "1", NETWORK_TEST, NETWORK_TEST);

        public static void register() {
            int packetID = 0;
            CHANNEL.registerMessage(packetID++, UpdateDimensionsPacket.class, UpdateDimensionsPacket::write, UpdateDimensionsPacket::read, UpdateDimensionsPacket::handle);
        }
    }

    @Mod.EventBusSubscriber(modid="ssm_reborn", bus=Mod.EventBusSubscriber.Bus.MOD)
    public class CommonModEvents {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(NetworkingSSM::register);
        }
    }

    @Mod.EventBusSubscriber(modid="ssm_reborn")
    private static class ForgeEventHandler {
        private ForgeEventHandler() {
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            MinecraftServer server;
            if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
                INSTANCE.unregisterScheduledDimensions(server);
            }
        }

        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            DynamicDimensionManager.INSTANCE.levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();
        }
    }
}

