/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm.DTimeDataStorage;
import xox.labvorty.ssm.ParallelSpacesUtil;
import xox.labvorty.ssm.SafetyRegions;
import xox.labvorty.ssm.network.SsmRebornModVariables;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntitySpawnEventChecker {
    public static List<String> dimension = new ArrayList<String>();
    public static List<Double> x1 = new ArrayList<Double>();
    public static List<Double> y1 = new ArrayList<Double>();
    public static List<Double> z1 = new ArrayList<Double>();
    public static List<Double> x2 = new ArrayList<Double>();
    public static List<Double> y2 = new ArrayList<Double>();
    public static List<Double> z2 = new ArrayList<Double>();
    public static List<Integer> lines = new ArrayList<Integer>();
    public static List<String> worlds = new ArrayList<String>();

    public static void updateCurrentData(List<String> dim, List<Double> xl1, List<Double> yl1, List<Double> zl1, List<Double> xl2, List<Double> yl2, List<Double> zl2) {
        dimension = dim;
        x1 = xl1;
        y1 = yl1;
        z1 = zl1;
        x2 = xl2;
        y2 = yl2;
        z2 = zl2;
    }

    public static void updateLineWorldData(List<Integer> lin, List<String> wor) {
        lines = lin;
        worlds = wor;
    }

    public static boolean isPlayerSafe(Entity entity) {
        String playerDim = entity.m_9236_().m_46472_().m_135782_().m_135827_() + ":" + entity.m_9236_().m_46472_().m_135782_().m_135815_();
        double playerX = entity.m_20185_();
        double playerY = entity.m_20186_();
        double playerZ = entity.m_20189_();
        if (playerDim.startsWith("ssm_reborn:time_wasteland") || playerDim.startsWith("ssm_reborn:synclyte") || playerDim.startsWith("ssm_reborn:synclyte_pocket_dimension")) {
            return true;
        }
        if (!lines.contains(ParallelSpacesUtil.getAltFromResourceLocation(entity.m_9236_().m_46472_().m_135782_()))) {
            return true;
        }
        if (SsmRebornModVariables.MapVariables.get((LevelAccessor)entity.m_9236_()).OnlyCertainWorldInDangerTime && !worlds.contains(playerDim)) {
            return true;
        }
        if (((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).TimeUnlinked) {
            return true;
        }
        if (dimension.contains(playerDim)) {
            for (int i = 0; i < dimension.size(); ++i) {
                if (!dimension.get(i).equals(playerDim)) continue;
                double minX = Math.min(x1.get(i), x2.get(i));
                double maxX = Math.max(x1.get(i), x2.get(i));
                double minY = Math.min(y1.get(i), y2.get(i));
                double maxY = Math.max(y1.get(i), y2.get(i));
                double minZ = Math.min(z1.get(i), z2.get(i));
                double maxZ = Math.max(z1.get(i), z2.get(i));
                if (!(playerX >= minX) || !(playerX <= maxX) || !(playerY >= minY) || !(playerY <= maxY) || !(playerZ >= minZ) || !(playerZ <= maxZ)) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public static void init(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        MobSpawnType spawnType = event.getSpawnType();
        ServerLevelAccessor slaccessor = event.getLevel();
        ServerLevel serverLevel = slaccessor.m_6018_();
        double dtime = SsmRebornModVariables.MapVariables.get((LevelAccessor)event.getLevel()).dangerLevelGlobal;
        SafetyRegions data = (SafetyRegions)serverLevel.m_8895_().m_164861_(SafetyRegions::load, SafetyRegions::new, "ssm_safety_regions");
        EntitySpawnEventChecker.updateCurrentData(data.dimension, data.x1, data.y1, data.z1, data.x2, data.y2, data.z2);
        DTimeDataStorage data1 = (DTimeDataStorage)serverLevel.m_8895_().m_164861_(DTimeDataStorage::load, DTimeDataStorage::new, "dtime_data_storage");
        EntitySpawnEventChecker.updateLineWorldData(data1.linesAffected, data1.worldsAffected);
        if (spawnType == MobSpawnType.MOB_SUMMONED || spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.DISPENSER || spawnType == MobSpawnType.BUCKET) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Player || entity instanceof ServerPlayer || !(dtime > 0.0) || EntitySpawnEventChecker.isPlayerSafe((Entity)entity) || livingEntity.m_21233_() > 60.0f || livingEntity.getPersistentData().m_128471_("TimeUnlinked"))) {
                event.setSpawnCancelled(true);
            }
        }
    }
}

