/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.world.inventory.PhoneIlliaUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IlliaPhonePacket {
    private final double x;
    private final double y;
    private final double z;

    public IlliaPhonePacket(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
    }

    public IlliaPhonePacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(IlliaPhonePacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.x);
        buffer.writeDouble(packet.y);
        buffer.writeDouble(packet.z);
    }

    public static void handler(IlliaPhonePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            double x = packet.x;
            double y = packet.y;
            double z = packet.z;
            if (context.getDirection().getReceptionSide().isServer()) {
                IlliaPhonePacket.sHandler((Player)player, x, y, z);
            }
        });
        context.setPacketHandled(true);
    }

    public static void sHandler(Player player, double x, double y, double z) {
        Level level = player.m_9236_();
        final BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            try {
                NetworkHooks.openScreen((ServerPlayer)sPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"PhoneIlliaUI");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player plr) {
                        return new PhoneIlliaUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(pos));
                    }
                }, (BlockPos)pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(IlliaPhonePacket.class, IlliaPhonePacket::buffer, IlliaPhonePacket::new, IlliaPhonePacket::handler);
    }
}

