/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import xox.labvorty.ssm.DynamicDimensionManager;

public class ParallelSpacesUtil {
    private static final String ALT_SUFFIX = "_line";

    public static void teleportPlayerToAlt(Player player, int alt, String mainDimKey, String modid) {
        ResourceKey mainDim;
        MinecraftServer server = player.m_20194_();
        if (server.m_129880_(mainDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(modid, mainDimKey))) != null) {
            ServerPlayer _player;
            ResourceKey altDimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("minecraft", "overworld"));
            if (alt == 0 || mainDim.m_135782_().m_135815_().startsWith("synclyte") || mainDim.m_135782_().m_135815_().startsWith("time_wasteland") || mainDim.m_135782_().m_135815_().startsWith("time_prison") || mainDim.m_135782_().m_135815_().startsWith("synclyte_pocket_dimension")) {
                altDimKey = mainDim;
            } else if (mainDimKey.contains(ALT_SUFFIX)) {
                int indexof = mainDimKey.indexOf(ALT_SUFFIX);
                String altMainKey = mainDimKey;
                if (indexof != -1) {
                    altMainKey = mainDimKey.substring(0, indexof);
                }
                altDimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(modid, altMainKey));
            } else {
                altDimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(modid, mainDimKey + ALT_SUFFIX + alt));
            }
            ServerLevel altDim = ParallelSpacesUtil.getOrCreateDimension(server, (ResourceKey<Level>)mainDim, (ResourceKey<Level>)altDimKey);
            if (player instanceof ServerPlayer && !(_player = (ServerPlayer)player).m_9236_().m_5776_()) {
                _player.m_8999_(altDim, _player.m_20185_(), _player.m_20186_(), _player.m_20189_(), _player.m_146908_(), _player.m_146909_());
            }
        }
    }

    public static ServerLevel getOrCreateDimension(MinecraftServer server, ResourceKey<Level> original, ResourceKey<Level> alternative) {
        ServerLevel originalLevel = server.m_129880_(original);
        if (originalLevel == null) {
            throw new IllegalStateException("Original dimension not found!");
        }
        LevelStem originalStem = (LevelStem)server.m_206579_().m_175515_(Registries.f_256862_).m_6246_(ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)original.m_135782_()));
        if (originalStem == null) {
            throw new IllegalStateException("Original dimension stem not found!");
        }
        return DynamicDimensionManager.INSTANCE.getOrCreateLevel(server, alternative, () -> new LevelStem(originalStem.f_63975_(), originalStem.f_63976_()));
    }

    public static int getAltFromResourceLocation(ResourceLocation location) {
        String path = location.m_135815_();
        if (!path.contains(ALT_SUFFIX)) {
            return 0;
        }
        int suffixIndex = path.indexOf(ALT_SUFFIX);
        String altPart = path.substring(suffixIndex + ALT_SUFFIX.length());
        try {
            return Integer.parseInt(altPart);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

