/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import xox.labvorty.ssm.DomeDataStorage;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SSMRebornAdditionalWorldRender {
    private static final ResourceLocation FORCEFIELD_SPHERE_TEXTURE = new ResourceLocation("minecraft", "textures/misc/forcefield.png");
    private static DomeDataStorage data = new DomeDataStorage();

    public static void updateDomeData(DomeDataStorage datas) {
        data = datas;
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            PoseStack poseStack = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            Camera cam = event.getCamera();
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            long ticks = mc.f_91073_.m_46467_();
            ClientLevel level = mc.f_91073_;
            String dimension = level.m_46472_().m_135782_().m_135827_() + ":" + level.m_46472_().m_135782_().m_135815_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (int i = 0; i < SSMRebornAdditionalWorldRender.data.dimension.size(); ++i) {
                if (!dimension.equals(SSMRebornAdditionalWorldRender.data.dimension.get(i))) continue;
                float radiusM = SSMRebornAdditionalWorldRender.data.radius.get(i).floatValue();
                double vred = SSMRebornAdditionalWorldRender.data.red.get(i);
                double vgreen = SSMRebornAdditionalWorldRender.data.green.get(i);
                double vblue = SSMRebornAdditionalWorldRender.data.blue.get(i);
                poseStack.m_85836_();
                poseStack.m_85837_((double)SSMRebornAdditionalWorldRender.data.posX.get(i).intValue() - cam.m_90583_().m_7096_(), (double)SSMRebornAdditionalWorldRender.data.posY.get(i).intValue() - cam.m_90583_().m_7098_(), (double)SSMRebornAdditionalWorldRender.data.posZ.get(i).intValue() - cam.m_90583_().m_7094_());
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)ticks / (20.0f / SSMRebornAdditionalWorldRender.data.rotSpeed.get(i).floatValue())));
                SSMRebornAdditionalWorldRender.renderSphereWithParameters(poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, radiusM, vred, vgreen, vblue);
                poseStack.m_85849_();
            }
            RenderSystem.disableBlend();
            bufferSource.m_109911_();
        }
    }

    private static void renderSphere(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)FORCEFIELD_SPHERE_TEXTURE));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        float baseRadius = 5.0f;
        int baseSlices = 32;
        int maxSlices = 128;
        float radius = 300.0f;
        int slices = (int)Mth.m_14036_((float)((float)baseSlices * (radius / baseRadius)), (float)16.0f, (float)maxSlices);
        int stacks = (int)Mth.m_14036_((float)((float)baseSlices * (radius / baseRadius)), (float)16.0f, (float)maxSlices);
        float tileU = (int)((double)baseSlices * 0.5 * (double)(radius / baseRadius));
        float tileV = (int)((double)baseSlices * 0.5 * (double)(radius / baseRadius));
        for (int i = 0; i < slices; ++i) {
            float u0 = (float)i / (float)slices * ((float)Math.PI * 2);
            float u1 = (float)(i + 1) / (float)slices * ((float)Math.PI * 2);
            for (int j = 0; j < stacks; ++j) {
                float v0 = (float)j / (float)stacks * (float)Math.PI;
                float v1 = (float)(j + 1) / (float)stacks * (float)Math.PI;
                float uvU0 = (float)i / (float)slices * tileU;
                float uvU1 = (float)(i + 1) / (float)slices * tileU;
                float uvV0 = (1.0f - (float)j / (float)stacks) * tileV;
                float uvV1 = (1.0f - (float)(j + 1) / (float)stacks) * tileV;
                Vector3f p0 = SSMRebornAdditionalWorldRender.parametricSphere(u0, v0, radius);
                Vector3f p1 = SSMRebornAdditionalWorldRender.parametricSphere(u0, v1, radius);
                Vector3f p2 = SSMRebornAdditionalWorldRender.parametricSphere(u1, v0, radius);
                Vector3f p3 = SSMRebornAdditionalWorldRender.parametricSphere(u1, v1, radius);
                consumer.m_252986_(matrix, p0.x(), p0.y(), p0.z()).m_6122_(0, 255, 255, 255).m_7421_(uvU0, uvV0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p1.x(), p1.y(), p1.z()).m_6122_(0, 255, 255, 255).m_7421_(uvU0, uvV1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p3.x(), p3.y(), p3.z()).m_6122_(0, 255, 255, 255).m_7421_(uvU1, uvV1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p2.x(), p2.y(), p2.z()).m_6122_(0, 255, 255, 255).m_7421_(uvU1, uvV0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
    }

    private static void renderSphereWithParameters(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float radiusM, double red, double green, double blue) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)FORCEFIELD_SPHERE_TEXTURE));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        float baseRadius = 5.0f;
        int baseSlices = 32;
        int maxSlices = 128;
        float radius = radiusM;
        int truered = Mth.m_14045_((int)((int)(red * 255.0)), (int)0, (int)255);
        int truegreen = Mth.m_14045_((int)((int)(green * 255.0)), (int)0, (int)255);
        int trueblue = Mth.m_14045_((int)((int)(blue * 255.0)), (int)0, (int)255);
        int slices = (int)Mth.m_14036_((float)((float)baseSlices * (radius / baseRadius)), (float)16.0f, (float)maxSlices);
        int stacks = (int)Mth.m_14036_((float)((float)baseSlices * (radius / baseRadius)), (float)16.0f, (float)maxSlices);
        float tileU = (int)((double)baseSlices * 0.5 * (double)(radius / baseRadius));
        float tileV = (int)((double)baseSlices * 0.5 * (double)(radius / baseRadius));
        for (int i = 0; i < slices; ++i) {
            float u0 = (float)i / (float)slices * ((float)Math.PI * 2);
            float u1 = (float)(i + 1) / (float)slices * ((float)Math.PI * 2);
            for (int j = 0; j < stacks; ++j) {
                float v0 = (float)j / (float)stacks * (float)Math.PI;
                float v1 = (float)(j + 1) / (float)stacks * (float)Math.PI;
                float uvU0 = (float)i / (float)slices * tileU;
                float uvU1 = (float)(i + 1) / (float)slices * tileU;
                float uvV0 = (1.0f - (float)j / (float)stacks) * tileV;
                float uvV1 = (1.0f - (float)(j + 1) / (float)stacks) * tileV;
                Vector3f p0 = SSMRebornAdditionalWorldRender.parametricSphere(u0, v0, radius);
                Vector3f p1 = SSMRebornAdditionalWorldRender.parametricSphere(u0, v1, radius);
                Vector3f p2 = SSMRebornAdditionalWorldRender.parametricSphere(u1, v0, radius);
                Vector3f p3 = SSMRebornAdditionalWorldRender.parametricSphere(u1, v1, radius);
                consumer.m_252986_(matrix, p0.x(), p0.y(), p0.z()).m_6122_(truered, truegreen, trueblue, 255).m_7421_(uvU0, uvV0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p1.x(), p1.y(), p1.z()).m_6122_(truered, truegreen, trueblue, 255).m_7421_(uvU0, uvV1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p3.x(), p3.y(), p3.z()).m_6122_(truered, truegreen, trueblue, 255).m_7421_(uvU1, uvV1).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, p2.x(), p2.y(), p2.z()).m_6122_(truered, truegreen, trueblue, 255).m_7421_(uvU1, uvV0).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }
}

