/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class SparkPowerConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("ssm_reborn", new String[0]);
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("sparkconfig.json");
    private static final int CURRENT_VERSION = 1200;

    public static void init() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject defaultConfig = SparkPowerConfig.createDefaultConfig();
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)SparkPowerConfig.createDefaultConfig()), new OpenOption[0]);
                return;
            }
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
                int fileVersion = config.get("version").getAsInt();
                String newConfigName = "old_sparkconfig.json";
                Path target = CONFIG_DIR.resolve(newConfigName);
                if (1200 > fileVersion) {
                    Files.copy(CONFIG_FILE, target, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(CONFIG_FILE);
                    Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)SparkPowerConfig.createDefaultConfig()), new OpenOption[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("version", (Number)1200);
        JsonObject overworld = new JsonObject();
        overworld.addProperty("chargeIndex", (Number)1.0);
        overworld.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject nether = new JsonObject();
        nether.addProperty("chargeIndex", (Number)1.0);
        nether.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject theend = new JsonObject();
        theend.addProperty("chargeIndex", (Number)0.0);
        theend.addProperty("canDusk", Boolean.valueOf(true));
        JsonObject worldvoid = new JsonObject();
        worldvoid.addProperty("chargeIndex", (Number)0.0);
        worldvoid.addProperty("canDusk", Boolean.valueOf(true));
        JsonObject timewasteland = new JsonObject();
        timewasteland.addProperty("chargeIndex", (Number)-1.0);
        timewasteland.addProperty("canDusk", Boolean.valueOf(true));
        JsonObject timeprison = new JsonObject();
        timeprison.addProperty("chargeIndex", (Number)0.0);
        timeprison.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject synclyte = new JsonObject();
        synclyte.addProperty("chargeIndex", (Number)0.0);
        synclyte.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject synclytePocket = new JsonObject();
        synclytePocket.addProperty("chargeIndex", (Number)0.0);
        synclytePocket.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject thirteen = new JsonObject();
        thirteen.addProperty("chargeIndex", (Number)2.0);
        thirteen.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject twentynine = new JsonObject();
        twentynine.addProperty("chargeIndex", (Number)1.0);
        twentynine.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject prunus = new JsonObject();
        prunus.addProperty("chargeIndex", (Number)0.0);
        prunus.addProperty("canDusk", Boolean.valueOf(true));
        JsonObject mortis = new JsonObject();
        mortis.addProperty("chargeIndex", (Number)1.0);
        mortis.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject misr = new JsonObject();
        misr.addProperty("chargeIndex", (Number)1.0);
        misr.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject arhei = new JsonObject();
        arhei.addProperty("chargeIndex", (Number)100.0);
        arhei.addProperty("canDusk", Boolean.valueOf(true));
        JsonObject arheiDangerous = new JsonObject();
        arheiDangerous.addProperty("chargeIndex", (Number)0.1);
        arheiDangerous.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject dream = new JsonObject();
        dream.addProperty("chargeIndex", (Number)100.0);
        dream.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject mindscape = new JsonObject();
        mindscape.addProperty("chargeIndex", (Number)0.0);
        mindscape.addProperty("canDusk", Boolean.valueOf(false));
        JsonObject cold = new JsonObject();
        cold.addProperty("chargeIndex", (Number)1.0);
        cold.addProperty("canDusk", Boolean.valueOf(false));
        config.add("minecraft:overworld", (JsonElement)overworld);
        config.add("minecraft:the_nether", (JsonElement)nether);
        config.add("minecraft:the_end", (JsonElement)theend);
        config.add("ssm_reborn:world_void", (JsonElement)worldvoid);
        config.add("ssm_reborn:time_wasteland", (JsonElement)timewasteland);
        config.add("ssm_reborn:time_prison", (JsonElement)timeprison);
        config.add("ssm_reborn:synclyte", (JsonElement)synclyte);
        config.add("ssm_reborn:synclyte_pocket_dimension", (JsonElement)synclytePocket);
        config.add("ssm_reborn:thirteen", (JsonElement)thirteen);
        config.add("ssm_reborn:twenty_nine", (JsonElement)twentynine);
        config.add("ssm_reborn:prunus", (JsonElement)prunus);
        config.add("ssm_reborn:mortis", (JsonElement)mortis);
        config.add("ssm_reborn:misr", (JsonElement)misr);
        config.add("ssm_reborn:arhei", (JsonElement)arhei);
        config.add("ssm_reborn:arhei_dangerous", (JsonElement)arheiDangerous);
        config.add("ssm_reborn:dream", (JsonElement)dream);
        config.add("ssm_reborn:mindscape", (JsonElement)mindscape);
        config.add("ssm_reborn:cold_world_biome", (JsonElement)cold);
        return config;
    }

    public static double getSparkPower(String dimName) {
        double data = 1.0;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            for (Map.Entry entry : config.entrySet()) {
                if (!dimName.startsWith((String)entry.getKey())) continue;
                data = ((JsonElement)entry.getValue()).getAsJsonObject().get("chargeIndex").getAsDouble();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static boolean getDimmableData(String dimName) {
        boolean data = false;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            for (Map.Entry entry : config.entrySet()) {
                if (!dimName.startsWith((String)entry.getKey())) continue;
                data = ((JsonElement)entry.getValue()).getAsJsonObject().get("canDusk").getAsBoolean();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

