/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import xox.labvorty.ssm.CjdDataStorage;
import xox.labvorty.ssm.DomeDataStorage;
import xox.labvorty.ssm.IlliaCurrencyStorage;
import xox.labvorty.ssm.JdbDataStorage;
import xox.labvorty.ssm.LodeMagicData;
import xox.labvorty.ssm.LodeSkintData;
import xox.labvorty.ssm.PickpocketBaseData;
import xox.labvorty.ssm.SSMRebornAdditionalWorldRender;
import xox.labvorty.ssm.SVShopData;
import xox.labvorty.ssm.SafetyRegions;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.UtkerMessageData;
import xox.labvorty.ssm.client.gui.ATMScreenVScreen;
import xox.labvorty.ssm.client.gui.LodeSkintMagicUIScreen;
import xox.labvorty.ssm.client.gui.LodeSkintTeleportationUIScreen;
import xox.labvorty.ssm.client.gui.PhoneIlliaUIScreen;
import xox.labvorty.ssm.client.gui.PickpocketScreen;
import xox.labvorty.ssm.client.gui.SVShopUIScreen;
import xox.labvorty.ssm.client.gui.UTKERUiScreen;
import xox.labvorty.ssm.procedures.DangerousParticlesActivationProcedure;
import xox.labvorty.ssm.procedures.DangerousParticlesEntityActivatorProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpecialDataSync {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(LodeSkintDataSyncMessage.class, LodeSkintDataSyncMessage::buffer, LodeSkintDataSyncMessage::new, LodeSkintDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(CjdDataStorageSyncMessage.class, CjdDataStorageSyncMessage::buffer, CjdDataStorageSyncMessage::new, CjdDataStorageSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(IlliaCurrencyStorageSyncMessage.class, IlliaCurrencyStorageSyncMessage::buffer, IlliaCurrencyStorageSyncMessage::new, IlliaCurrencyStorageSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(JdbDataStorageSyncMessage.class, JdbDataStorageSyncMessage::buffer, JdbDataStorageSyncMessage::new, JdbDataStorageSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(LodeMagicDataSyncMessage.class, LodeMagicDataSyncMessage::buffer, LodeMagicDataSyncMessage::new, LodeMagicDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(SafetyRegionsSyncMessage.class, SafetyRegionsSyncMessage::buffer, SafetyRegionsSyncMessage::new, SafetyRegionsSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(SVShopDataSyncMessage.class, SVShopDataSyncMessage::buffer, SVShopDataSyncMessage::new, SVShopDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(UtkerMessageDataSyncMessage.class, UtkerMessageDataSyncMessage::buffer, UtkerMessageDataSyncMessage::new, UtkerMessageDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(PickpocketBaseDataSyncMessage.class, PickpocketBaseDataSyncMessage::buffer, PickpocketBaseDataSyncMessage::new, PickpocketBaseDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(DomeDataStorageSyncMessage.class, DomeDataStorageSyncMessage::buffer, DomeDataStorageSyncMessage::new, DomeDataStorageSyncMessage::handler);
    }

    public static class LodeSkintDataSyncMessage {
        public int type;
        public LodeSkintData data;

        public LodeSkintDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new LodeSkintData();
            if (tag != null) {
                this.data.loadS(tag);
            }
        }

        public LodeSkintDataSyncMessage(int type, LodeSkintData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(LodeSkintDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(LodeSkintDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        LodeSkintTeleportationUIScreen.syncData(message.data.names, message.data.posX, message.data.posY, message.data.posZ, message.data.imgId);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class CjdDataStorageSyncMessage {
        public int type;
        public CjdDataStorage data;

        public CjdDataStorageSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new CjdDataStorage();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public CjdDataStorageSyncMessage(int type, CjdDataStorage data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(CjdDataStorageSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(CjdDataStorageSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        PhoneIlliaUIScreen.updateCjdData(message.data.cjdOwner, message.data.cjdDate, message.data.cjdAddressTo, message.data.cjdAddressFrom);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class IlliaCurrencyStorageSyncMessage {
        public int type;
        public IlliaCurrencyStorage data;

        public IlliaCurrencyStorageSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new IlliaCurrencyStorage();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public IlliaCurrencyStorageSyncMessage(int type, IlliaCurrencyStorage data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(IlliaCurrencyStorageSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(IlliaCurrencyStorageSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        PhoneIlliaUIScreen.updateCurrency(message.data.nameUser, message.data.amountOfV, message.data.amountOfShopPoints);
                        ATMScreenVScreen.updateCurrency(message.data.nameUser, message.data.amountOfV, message.data.amountOfShopPoints);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class JdbDataStorageSyncMessage {
        public int type;
        public JdbDataStorage data;

        public JdbDataStorageSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new JdbDataStorage();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public JdbDataStorageSyncMessage(int type, JdbDataStorage data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(JdbDataStorageSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(JdbDataStorageSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        PhoneIlliaUIScreen.updateJdbData(message.data.nameUser, message.data.isDeduct, message.data.amountV, message.data.infoV);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class LodeMagicDataSyncMessage {
        public int type;
        public LodeMagicData data;

        public LodeMagicDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new LodeMagicData();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public LodeMagicDataSyncMessage(int type, LodeMagicData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(LodeMagicDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(LodeMagicDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        LodeSkintMagicUIScreen.syncSpells(message.data.ownerName, message.data.spellType);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class SafetyRegionsSyncMessage {
        public int type;
        public SafetyRegions data;

        public SafetyRegionsSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new SafetyRegions();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public SafetyRegionsSyncMessage(int type, SafetyRegions data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SafetyRegionsSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SafetyRegionsSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        if (message.data != null) {
                            DangerousParticlesActivationProcedure.updateCurrentData(message.data.dimension, message.data.x1, message.data.y1, message.data.z1, message.data.x2, message.data.y2, message.data.z2);
                            DangerousParticlesEntityActivatorProcedure.updateCurrentData(message.data.dimension, message.data.x1, message.data.y1, message.data.z1, message.data.x2, message.data.y2, message.data.z2);
                        } else {
                            SsmRebornMod.LOGGER.info("Failed to send data to server!");
                        }
                    }
                } else if (message.type == 0 && message.data != null) {
                    DangerousParticlesActivationProcedure.updateCurrentData(message.data.dimension, message.data.x1, message.data.y1, message.data.z1, message.data.x2, message.data.y2, message.data.z2);
                    DangerousParticlesEntityActivatorProcedure.updateCurrentData(message.data.dimension, message.data.x1, message.data.y1, message.data.z1, message.data.x2, message.data.y2, message.data.z2);
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class SVShopDataSyncMessage {
        public int type;
        public SVShopData data;

        public SVShopDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new SVShopData();
            if (tag != null) {
                this.data.loadinst(tag);
            }
        }

        public SVShopDataSyncMessage(int type, SVShopData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SVShopDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SVShopDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        SVShopUIScreen.syncData(message.data.shopID, message.data.item, message.data.price);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class UtkerMessageDataSyncMessage {
        public int type;
        public UtkerMessageData data;

        public UtkerMessageDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new UtkerMessageData();
            if (tag != null) {
                this.data.loadS(tag);
            }
        }

        public UtkerMessageDataSyncMessage(int type, UtkerMessageData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(UtkerMessageDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(UtkerMessageDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        UTKERUiScreen.updateData(message.data.customq, message.data.customa, message.data.requirements, message.data.modifier, message.data.modifyto);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PickpocketBaseDataSyncMessage {
        public int type;
        public PickpocketBaseData data;

        public PickpocketBaseDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new PickpocketBaseData();
            if (tag != null) {
                this.data.loadS(tag);
            }
        }

        public PickpocketBaseDataSyncMessage(int type, PickpocketBaseData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(PickpocketBaseDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(PickpocketBaseDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        PickpocketScreen.updateBaseData(message.data.screenid, message.data.item, message.data.minamount, message.data.maxamount, message.data.chance, message.data.shouldDisplay);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class DomeDataStorageSyncMessage {
        public int type;
        public DomeDataStorage data;

        public DomeDataStorageSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag tag = buffer.m_130260_();
            this.data = new DomeDataStorage();
            if (tag != null) {
                this.data.loadS(tag);
            }
        }

        public DomeDataStorageSyncMessage(int type, DomeDataStorage data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(DomeDataStorageSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(DomeDataStorageSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.type == 0) {
                    if (message.data != null) {
                        SSMRebornAdditionalWorldRender.updateDomeData(message.data);
                    } else {
                        SsmRebornMod.LOGGER.info("Failed to send data to client!");
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlersNew {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                LodeSkintData data = LodeSkintData.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                CjdDataStorage data1 = CjdDataStorage.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                IlliaCurrencyStorage data2 = IlliaCurrencyStorage.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                JdbDataStorage data3 = JdbDataStorage.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                LodeMagicData data4 = LodeMagicData.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                SafetyRegions data5 = SafetyRegions.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                SVShopData data6 = SVShopData.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                UtkerMessageData data7 = UtkerMessageData.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                PickpocketBaseData data8 = PickpocketBaseData.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                DomeDataStorage data9 = DomeDataStorage.getUsingServer((LevelAccessor)event.getEntity().m_9236_());
                if (data != null) {
                    ServerPlayer player = (ServerPlayer)event.getEntity();
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LodeSkintDataSyncMessage(0, data));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CjdDataStorageSyncMessage(0, data1));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new IlliaCurrencyStorageSyncMessage(0, data2));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new JdbDataStorageSyncMessage(0, data3));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LodeMagicDataSyncMessage(0, data4));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SafetyRegionsSyncMessage(0, data5));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SVShopDataSyncMessage(0, data6));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UtkerMessageDataSyncMessage(0, data7));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PickpocketBaseDataSyncMessage(0, data8));
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new DomeDataStorageSyncMessage(0, data9));
                } else {
                    SsmRebornMod.LOGGER.info("Data null in login phase!");
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Component displayName = event.player.m_5446_();
                String displayTrueName = displayName.getString();
                if (!event.player.m_9236_().m_5776_()) {
                    LodeSkintData data = LodeSkintData.getUsingServer((LevelAccessor)event.player.m_9236_());
                    CjdDataStorage data1 = CjdDataStorage.getUsingServer((LevelAccessor)event.player.m_9236_());
                    IlliaCurrencyStorage data2 = IlliaCurrencyStorage.getUsingServer((LevelAccessor)event.player.m_9236_());
                    JdbDataStorage data3 = JdbDataStorage.getUsingServer((LevelAccessor)event.player.m_9236_());
                    LodeMagicData data4 = LodeMagicData.getUsingServer((LevelAccessor)event.player.m_9236_());
                    SafetyRegions data5 = SafetyRegions.getUsingServer((LevelAccessor)event.player.m_9236_());
                    SVShopData data6 = SVShopData.getUsingServer((LevelAccessor)event.player.m_9236_());
                    UtkerMessageData data7 = UtkerMessageData.getUsingServer((LevelAccessor)event.player.m_9236_());
                    PickpocketBaseData data8 = PickpocketBaseData.getUsingServer((LevelAccessor)event.player.m_9236_());
                    DomeDataStorage data9 = DomeDataStorage.getUsingServer((LevelAccessor)event.player.m_9236_());
                    if (!data2.nameUser.contains(displayTrueName)) {
                        data2.addData(displayTrueName, 0, 0);
                        SsmRebornMod.LOGGER.info("New user confirmed! Username: " + displayTrueName);
                    }
                    if (data != null) {
                        ServerPlayer player = (ServerPlayer)event.player;
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LodeSkintDataSyncMessage(0, data));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CjdDataStorageSyncMessage(0, data1));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new IlliaCurrencyStorageSyncMessage(0, data2));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new JdbDataStorageSyncMessage(0, data3));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LodeMagicDataSyncMessage(0, data4));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SafetyRegionsSyncMessage(0, data5));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SVShopDataSyncMessage(0, data6));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UtkerMessageDataSyncMessage(0, data7));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PickpocketBaseDataSyncMessage(0, data8));
                        SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new DomeDataStorageSyncMessage(0, data9));
                    }
                }
            }
        }
    }
}

