/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xox.labvorty.ssm.TheSendingParticleOptions;

@OnlyIn(value=Dist.CLIENT)
public class TheSendingParticle<T extends TheSendingParticleOptions>
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    protected double centerx;
    protected double centery;
    protected double centerz;
    protected double degreesx;
    protected double degreesy;
    protected double degreesz;
    protected double speedx;
    protected double speedy;
    protected double speedz;
    protected double startx;
    protected double starty;
    protected double startz;
    protected double radius;
    protected double currentdegrees;
    protected double specradius;
    protected boolean initialized;

    public static TheSendingParticleProvider provider(SpriteSet spriteSet) {
        return new TheSendingParticleProvider(spriteSet);
    }

    protected TheSendingParticle(ClientLevel clevel, double x, double y, double z, double vx, double vy, double vz, T options, SpriteSet spriteSet) {
        super(clevel, x, y, z, vx, vy, vz);
        this.spriteSet = spriteSet;
        this.m_107250_(0.15f, 0.15f);
        this.f_107225_ = 360;
        this.f_107226_ = 0.0f;
        this.f_107219_ = true;
        this.f_107227_ = ((TheSendingParticleOptions)options).getColor().x();
        this.f_107228_ = ((TheSendingParticleOptions)options).getColor().y();
        this.f_107229_ = ((TheSendingParticleOptions)options).getColor().z();
        this.centerx = ((TheSendingParticleOptions)options).getCenterX();
        this.centery = ((TheSendingParticleOptions)options).getCenterY();
        this.centerz = ((TheSendingParticleOptions)options).getCenterZ();
        this.degreesx = ((TheSendingParticleOptions)options).getDegreesX();
        this.degreesy = ((TheSendingParticleOptions)options).getDegreesY();
        this.degreesz = ((TheSendingParticleOptions)options).getDegreesZ();
        this.speedx = ((TheSendingParticleOptions)options).getSpeedX();
        this.speedy = ((TheSendingParticleOptions)options).getSpeedY();
        this.speedz = ((TheSendingParticleOptions)options).getSpeedZ();
        this.startx = x;
        this.starty = y;
        this.startz = z;
        this.radius = Math.sqrt(Math.pow(x - this.centerx, 2.0) + Math.pow(y - this.centery, 2.0) + Math.pow(z - this.centerz, 2.0));
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.m_108335_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public void m_5989_() {
        super.m_5989_();
        float ageRatio = (float)this.f_107224_ / (float)this.f_107225_;
        this.m_6569_(1.0f * (1.0f - ageRatio));
        double relX = this.f_107212_ - this.centerx;
        double relY = this.f_107213_ - this.centery;
        double relZ = this.f_107214_ - this.centerz;
        double radius = Math.sqrt(relX * relX + relY * relY + relZ * relZ);
        double theta = Math.atan2(relZ, relX);
        double phi = Math.acos(relY / radius);
        double modx = this.f_107212_ + Math.cos(Math.toRadians(this.degreesx)) * this.speedx;
        double mody = this.f_107213_ + Math.sin(Math.toRadians(this.degreesy)) * this.speedy;
        double modz = this.f_107214_ + Math.sin(Math.toRadians(this.degreesz)) * this.speedz;
        Vec3 deltaRot = this.getDeltaRotation(new Vec3(this.degreesx, this.degreesy, this.degreesz), new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), new Vec3(this.centerx, this.centery, this.centerz));
        this.degreesx += deltaRot.m_7096_();
        this.degreesy += deltaRot.m_7098_();
        this.degreesz += deltaRot.m_7094_();
        this.m_107264_(modx, mody, modz);
    }

    public double calculateDegrees(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public double normalizeAngle(double angle) {
        if ((angle %= 360.0) > 180.0) {
            angle -= 360.0;
        }
        if (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public Vec2 calculateTargetYawPitch(double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        double dx = toX - fromX;
        double dy = toY - fromY;
        double dz = toZ - fromZ;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        double yaw = Math.toDegrees(Math.atan2(dz, dx));
        double pitch = Math.toDegrees(Math.atan2(dy, horizontalDistance));
        return new Vec2((float)this.normalizeAngle(yaw), (float)this.normalizeAngle(pitch));
    }

    public Vec3 getDeltaRotation(Vec3 currentRotation, Vec3 position, Vec3 center) {
        Vec2 targetYawPitch = this.calculateTargetYawPitch(position.f_82479_, position.f_82480_, position.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_);
        double deltaPitch = this.normalizeAngle((double)targetYawPitch.f_82471_ - currentRotation.f_82479_);
        double deltaYaw = this.normalizeAngle((double)targetYawPitch.f_82470_ - currentRotation.f_82480_);
        double deltaRoll = this.normalizeAngle(0.0 - currentRotation.f_82481_);
        return new Vec3(deltaPitch, deltaYaw, deltaRoll);
    }

    public static class TheSendingParticleProvider
    implements ParticleProvider<TheSendingParticleOptions> {
        private final SpriteSet spriteSet;

        public TheSendingParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(TheSendingParticleOptions typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TheSendingParticle<TheSendingParticleOptions>(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn, this.spriteSet);
        }
    }
}

